/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.Range;
import com.jetbrains.nodejs.packageJson.NodeJsPackageDocumentation;
import com.jetbrains.nodejs.util.MarkdownUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsPackageDocUtil {
    private NodeJsPackageDocUtil() {
    }

    @Nullable
    public static NodeJsPackageDocumentation createByPackageDir(@NotNull VirtualFile packageDir, boolean showReadme) {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "createByPackageDir"));
        }
        Holder holder = (Holder)ReadAction.compute(() -> {
            if (packageDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "lambda$createByPackageDir$0"));
            }
            VirtualFile packageJson = packageDir.findChild("package.json");
            if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory()) {
                PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)packageJson);
                VirtualFile markdownFile = showReadme ? NodeJsPackageDocUtil.findReadmeMarkdownFile(packageDir) : null;
                return new Holder(NodeJsPackageDocUtil.getPackageName(packageDir), data.getDescription(), markdownFile);
            }
            return null;
        });
        if (holder != null) {
            String html = NodeJsPackageDocUtil.generateHtml(holder.myReadmeMd);
            return new NodeJsPackageDocumentation(holder.myPackageName, holder.myDescription, html);
        }
        return null;
    }

    @NotNull
    private static String getPackageName(@NotNull VirtualFile packageDir) {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "getPackageName"));
        }
        VirtualFile parent = packageDir.getParent();
        if (parent == null || NodeModulesDirectoryManager.isNodeModulesDir((VirtualFile)parent)) {
            String string = packageDir.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "getPackageName"));
            }
            return string;
        }
        String compoundName = parent.getName() + "/" + packageDir.getName();
        String string = compoundName.startsWith("@") ? compoundName : packageDir.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "getPackageName"));
        }
        return string;
    }

    @Nullable
    private static VirtualFile findReadmeMarkdownFile(@NotNull VirtualFile packageDir) {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "findReadmeMarkdownFile"));
        }
        VirtualFile[] children = packageDir.getChildren();
        if (children != null) {
            for (VirtualFile child : children) {
                String name;
                if (!child.isValid() || !(name = child.getName()).equalsIgnoreCase("readme.md") && !name.equalsIgnoreCase("readme.markdown")) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    private static String loadText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "loadText"));
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            String string = document.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "loadText"));
            }
            return string;
        }
        String string = VfsUtilCore.loadText((VirtualFile)file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "loadText"));
        }
        return string;
    }

    @Nullable
    private static String generateHtml(@Nullable VirtualFile readmeMd) {
        if (readmeMd == null) {
            return null;
        }
        try {
            String markdown = NodeJsPackageDocUtil.loadText(readmeMd);
            if (StringUtil.isEmptyOrSpaces((String)markdown)) {
                return null;
            }
            markdown = NodeJsPackageDocUtil.removeUselessImageLinks(markdown);
            return MarkdownUtil.toHtml(markdown);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static String removeUselessImageLinks(@NotNull String markdown) {
        if (markdown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markdown", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "removeUselessImageLinks"));
        }
        List<String> lines = Arrays.asList(StringUtil.splitByLinesDontTrim((String)markdown));
        Range<Integer> uselessLines = NodeJsPackageDocUtil.findUselessLineRange(lines);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            if (uselessLines != null && uselessLines.isWithin((Comparable)Integer.valueOf(i))) continue;
            String line = lines.get(i);
            String usefulLine = NodeJsPackageDocUtil.clearUselessLinks(line);
            if (!StringUtil.isEmptyOrSpaces((String)line) && StringUtil.isEmptyOrSpaces((String)usefulLine)) continue;
            result.add(usefulLine);
        }
        String string = StringUtil.join(result, (String)LineSeparator.LF.getSeparatorString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "removeUselessImageLinks"));
        }
        return string;
    }

    @Nullable
    private static Range<Integer> findUselessLineRange(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "findUselessLineRange"));
        }
        Range<Integer> range = NodeJsPackageDocUtil.findImageLinkRange(lines, 0);
        while (range != null) {
            boolean found = false;
            for (int i = ((Integer)range.getFrom()).intValue(); i <= (Integer)range.getTo(); ++i) {
                String line = lines.get(i);
                if (!NodeJsPackageDocUtil.isUselessImageLink(line, new TextRange(0, line.length()))) continue;
                found = true;
                break;
            }
            if (found) {
                return range;
            }
            range = NodeJsPackageDocUtil.findImageLinkRange(lines, (Integer)range.getTo() + 1);
        }
        return null;
    }

    @NotNull
    private static String clearUselessLinks(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "clearUselessLinks"));
        }
        TextRange link = NodeJsPackageDocUtil.findUselessLink(line, 0);
        if (link == null) {
            String string = line;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "clearUselessLinks"));
            }
            return string;
        }
        int lastLinkEnd = 0;
        StringBuilder result = new StringBuilder();
        while (link != null) {
            result.append(line.substring(lastLinkEnd, link.getStartOffset()));
            lastLinkEnd = link.getEndOffset();
            link = NodeJsPackageDocUtil.findUselessLink(line, lastLinkEnd);
        }
        result.append(line.substring(lastLinkEnd));
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "clearUselessLinks"));
        }
        return string;
    }

    @Nullable
    private static TextRange findUselessLink(@NotNull String text, int startIndex) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "findUselessLink"));
        }
        TextRange link = NodeJsPackageDocUtil.findImageLink(text, startIndex);
        while (link != null && !NodeJsPackageDocUtil.isUselessImageLink(text, link)) {
            link = NodeJsPackageDocUtil.findImageLink(text, link.getEndOffset());
        }
        return link;
    }

    private static boolean isUselessImageLink(@NotNull String text, @NotNull TextRange link) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "isUselessImageLink"));
        }
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "isUselessImageLink"));
        }
        String linkText = link.substring(text);
        return linkText.contains("travis-ci.org/") || linkText.contains("coveralls.io/") || linkText.contains("img.shields.io/") || linkText.contains("snyk.io/") || linkText.contains("gitter.im/") || linkText.contains("david-dm.org/") || linkText.contains("gratipay") || linkText.contains("npmjs.org/") || linkText.contains("codersclan") || linkText.contains("ci.testling.com/") || linkText.contains("[npm-url]") || linkText.contains("[npm-url]") || linkText.contains("[travis-url]") || linkText.contains("[coveralls-url]") || linkText.contains("[depstat-url]") || linkText.contains("ci.appveyor.com/") || linkText.contains("discord.gg/") || linkText.contains("/nodei.co/");
    }

    @Nullable
    private static TextRange findImageLink(@NotNull String text, int startIndex) {
        int urlClosingInd;
        int titleClosingInd;
        int mdStartInd;
        int htmlImgEndInd;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "findImageLink"));
        }
        TextRange htmlImgRange = null;
        int htmlImgStartInd = text.indexOf("<img ", startIndex);
        if (htmlImgStartInd >= 0 && (htmlImgEndInd = text.indexOf(">", htmlImgStartInd)) != -1) {
            htmlImgRange = new TextRange(htmlImgStartInd, htmlImgEndInd + 1);
        }
        if ((mdStartInd = text.indexOf("![", startIndex)) < 0 || htmlImgRange != null && htmlImgRange.getStartOffset() < mdStartInd) {
            return htmlImgRange;
        }
        int titleOpeningInd = mdStartInd + 1;
        if (mdStartInd > 0 && text.charAt(mdStartInd - 1) == '[') {
            mdStartInd = titleOpeningInd = mdStartInd - 1;
        }
        if ((titleClosingInd = NodeJsPackageDocUtil.findClosingInd(text, titleOpeningInd)) != -1 && (urlClosingInd = NodeJsPackageDocUtil.findClosingInd(text, titleClosingInd + 1)) != -1) {
            return new TextRange(mdStartInd, urlClosingInd + 1);
        }
        return null;
    }

    private static int findClosingInd(@NotNull String text, int openingInd) {
        int i;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "findClosingInd"));
        }
        int squareBrackets = 0;
        int parentheses = 0;
        boolean empty = true;
        for (i = openingInd; i < text.length() && (empty || squareBrackets > 0 || parentheses > 0); ++i) {
            char ch = text.charAt(i);
            if (ch == '[') {
                ++squareBrackets;
            } else if (ch == '(') {
                ++parentheses;
            } else if (ch == ']') {
                --squareBrackets;
            } else if (ch == ')') {
                --parentheses;
            }
            if (squareBrackets < 0 || parentheses < 0) {
                return -1;
            }
            if (empty && squareBrackets == 0 && parentheses == 0) {
                return -1;
            }
            empty = false;
        }
        return !empty && squareBrackets == 0 && parentheses == 0 ? i - 1 : -1;
    }

    @Nullable
    private static Range<Integer> findImageLinkRange(@NotNull List<String> lines, int startInd) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "findImageLinkRange"));
        }
        int rangeStartInd = -1;
        int rangeEndInd = -1;
        for (int i = startInd; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (NodeJsPackageDocUtil.isImageLinks(line)) {
                if (rangeStartInd == -1) {
                    rangeStartInd = i;
                }
                rangeEndInd = i;
                continue;
            }
            if (rangeStartInd != -1) break;
        }
        return rangeStartInd == -1 ? null : new Range((Comparable)Integer.valueOf(rangeStartInd), (Comparable)Integer.valueOf(rangeEndInd));
    }

    private static boolean isImageLinks(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil", "isImageLinks"));
        }
        int i = 0;
        while (i < line.length()) {
            while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            TextRange link = NodeJsPackageDocUtil.findImageLink(line, i);
            if (link == null || link.getStartOffset() != i) break;
            i = link.getEndOffset();
        }
        while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        return i == line.length();
    }

    private static class Holder {
        private String myPackageName;
        private String myDescription;
        private VirtualFile myReadmeMd;

        public Holder(@NotNull String packageName, @Nullable String description, @Nullable VirtualFile readmeMd) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocUtil$Holder", "<init>"));
            }
            this.myPackageName = packageName;
            this.myDescription = description;
            this.myReadmeMd = readmeMd;
        }
    }
}

