/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson;

import com.intellij.lang.javascript.EmbeddedJsonSchemaFileProvider;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    private static final String JSON_SCHEMA_FILENAME = "packageJsonSchema.json";
    private final List<JsonSchemaFileProvider> myProviders = Collections.singletonList(PackageJsonSchemaProviderFactory.createProvider());

    @NotNull
    private static JsonSchemaFileProvider createProvider() {
        EmbeddedJsonSchemaFileProvider embeddedJsonSchemaFileProvider = new EmbeddedJsonSchemaFileProvider(JSON_SCHEMA_FILENAME, PackageJsonSchemaProviderFactory.class, "", new String[]{"package.json"}){

            public boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/packageJson/PackageJsonSchemaProviderFactory$1", "isAvailable"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/packageJson/PackageJsonSchemaProviderFactory$1", "isAvailable"));
                }
                return PackageJsonUtil.isPackageJsonFile((VirtualFile)file);
            }
        }.setOrder(2);
        if (embeddedJsonSchemaFileProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonSchemaProviderFactory", "createProvider"));
        }
        return embeddedJsonSchemaFileProvider;
    }

    public List<JsonSchemaFileProvider> getProviders(@Nullable Project project) {
        return this.myProviders;
    }
}

