/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.google.common.collect.ImmutableList;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageInfo {
    private final String myPackageName;
    private final String myDescription;
    private final ImmutableList<String> myVersions;
    private final String myLatestVersion;
    private final String myAuthor;
    private final String myRepositoryUrl;

    public NodePackageInfo(@NotNull String packageName, @NotNull String description, @NotNull List<String> versions, @Nullable String latestVersion, @Nullable String author, @Nullable String repositoryUrl) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageInfo", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/jetbrains/nodejs/packages/NodePackageInfo", "<init>"));
        }
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/jetbrains/nodejs/packages/NodePackageInfo", "<init>"));
        }
        this.myPackageName = packageName;
        this.myDescription = description;
        this.myVersions = ImmutableList.copyOf(versions);
        this.myLatestVersion = latestVersion;
        this.myAuthor = author;
        this.myRepositoryUrl = repositoryUrl;
    }

    @NotNull
    public ImmutableList<String> getVersions() {
        ImmutableList<String> immutableList = this.myVersions;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageInfo", "getVersions"));
        }
        return immutableList;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageInfo", "getDescription"));
        }
        return string;
    }

    @Nullable
    public String getLatestVersion() {
        return this.myLatestVersion;
    }

    @NotNull
    public String formatHtmlDescription() {
        StringBuilder buf = new StringBuilder();
        NodePackageInfo.addSection(buf, null, this.myDescription, false);
        NodePackageInfo.addSection(buf, "Version", this.myLatestVersion, false);
        NodePackageInfo.addSection(buf, "Author", this.myAuthor, false);
        NodePackageInfo.addSection(buf, "Repository", this.myRepositoryUrl, true);
        NodePackageInfo.addSection(buf, "More details", "https://npmjs.org/package/" + this.myPackageName, true);
        String string = NodePackageInfo.createHtml(buf.toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageInfo", "formatHtmlDescription"));
        }
        return string;
    }

    @NotNull
    public static String createHtml(@NotNull String innerBodyHtml) {
        if (innerBodyHtml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerBodyHtml", "com/jetbrains/nodejs/packages/NodePackageInfo", "createHtml"));
        }
        Font font = UIUtil.getLabelFont();
        String string = "<html><head>" + UIUtil.getCssFontDeclaration((Font)font, null, null, null) + "<style>h4 {font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;}</style></head><body>" + innerBodyHtml + "</body></html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageInfo", "createHtml"));
        }
        return string;
    }

    private static void addSection(@NotNull StringBuilder buf, @Nullable String title, @Nullable String data, boolean url) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/jetbrains/nodejs/packages/NodePackageInfo", "addSection"));
        }
        if (data != null) {
            if (title != null) {
                buf.append("<h4>").append(StringEscapeUtils.escapeHtml((String)title)).append("</h4>");
            }
            if (url) {
                buf.append("<a href=\"").append(data).append("\">").append(StringEscapeUtils.escapeHtml((String)data)).append("</a>");
            } else {
                buf.append(StringEscapeUtils.escapeHtml((String)data));
            }
            buf.append("<br/>");
        }
    }
}

