/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.nodejs.packages.NodePackageInfo;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageInfoException
extends IOException {
    private final String myCommandLine;
    private final int myExitCode;
    private final String myStdOut;
    private final String myStdErr;

    public NodePackageInfoException(@NotNull String commandLine, int exitCode, @NotNull String stdOut, @NotNull String stdErr) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/packages/NodePackageInfoException", "<init>"));
        }
        if (stdOut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdOut", "com/jetbrains/nodejs/packages/NodePackageInfoException", "<init>"));
        }
        if (stdErr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdErr", "com/jetbrains/nodejs/packages/NodePackageInfoException", "<init>"));
        }
        super("FAILED COMMAND: " + commandLine + "\nEXIT CODE: " + exitCode + "\nSTDOUT:\n" + stdOut + "\nSTDERR:\n" + stdErr);
        this.myCommandLine = commandLine;
        this.myExitCode = exitCode;
        this.myStdOut = stdOut;
        this.myStdErr = stdErr;
    }

    @NotNull
    public String formatHtmlDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("<h4 style='color:red'>").append("Failed to load details: command returns non-zero exit code").append("</h4>");
        NodePackageInfoException.addSection(buf, "Command line", this.myCommandLine);
        if (StringUtil.isNotEmpty((String)this.myStdOut)) {
            NodePackageInfoException.addSection(buf, "Standard output", this.myStdOut);
        }
        NodePackageInfoException.addSection(buf, "Standard error", this.myStdErr);
        NodePackageInfoException.addSection(buf, "Process finished with exit code " + this.myExitCode, null);
        String string = NodePackageInfo.createHtml(buf.toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageInfoException", "formatHtmlDescription"));
        }
        return string;
    }

    private static void addSection(@NotNull StringBuilder buf, @Nullable String title, @Nullable String data) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/jetbrains/nodejs/packages/NodePackageInfoException", "addSection"));
        }
        if (title != null) {
            buf.append("<h4>").append(StringEscapeUtils.escapeHtml((String)title)).append("</h4>");
        }
        if (data != null) {
            buf.append("<div style='padding-left:5px'><pre><code>");
            buf.append(StringEscapeUtils.escapeHtml((String)data));
            buf.append("</code></pre></div>");
        }
    }
}

