/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.nodejs.packages.NodeInstalledPackage;
import com.jetbrains.nodejs.packages.NodeInstalledPackagesProvider;
import com.jetbrains.nodejs.packages.NodePackageInfo;
import com.jetbrains.nodejs.packages.NodePackageInfoException;
import com.jetbrains.nodejs.packages.NodePackageInfoManager;
import com.jetbrains.nodejs.packages.NodePackageListProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageManagementService
extends PackageManagementServiceEx {
    private static final Logger LOG = Logger.getInstance(NodePackageManagementService.class);
    private final Project myProject;
    private final NodeJsLocalInterpreter myInterpreter;
    private final NodePackageInfoManager myManager;

    public NodePackageManagementService(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/packages/NodePackageManagementService", "<init>"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/packages/NodePackageManagementService", "<init>"));
        }
        this.myProject = project;
        this.myInterpreter = interpreter;
        this.myManager = new NodePackageInfoManager(interpreter);
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version1", "com/jetbrains/nodejs/packages/NodePackageManagementService", "compareVersions"));
        }
        if (version2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version2", "com/jetbrains/nodejs/packages/NodePackageManagementService", "compareVersions"));
        }
        return NodePackageVersionUtil.comparePackageVersions((String)version1, (String)version2);
    }

    public List<RepoPackage> getAllPackages() throws IOException {
        List<String> names = NodePackageListProvider.getInstance().listAllRemotePackageNames();
        return ContainerUtil.map(names, name -> new RepoPackage(name, null, null));
    }

    public List<RepoPackage> reloadAllPackages() throws IOException {
        return this.getAllPackages();
    }

    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        NodeInstalledPackagesProvider provider = NodeInstalledPackagesProvider.getInstance();
        VirtualFile dir = this.myProject.getBaseDir();
        File ioDir = null;
        if (dir != null && dir.isValid() && dir.isDirectory()) {
            ioDir = new File(dir.getPath());
        }
        Collection<NodeInstalledPackage> nodePackages = provider.listInstalledPackages(ioDir, this.myInterpreter);
        NodeInstalledPackage[] array = nodePackages.toArray(new NodeInstalledPackage[nodePackages.size()]);
        Arrays.sort(array, (p1, p2) -> {
            if (p1.isGlobal() != p2.isGlobal()) {
                return p1.isGlobal() ? 1 : -1;
            }
            return p1.getName().compareTo(p2.getName());
        });
        return Arrays.asList(array);
    }

    public void installPackage(RepoPackage repoPackage, @Nullable String version, boolean forceUpgrade, @Nullable String extraOptions, PackageManagementService.Listener listener, boolean installToUser) {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir == null) {
            return;
        }
        UsageTrigger.trigger((String)"Npm.Packages.Install.Package");
        ProgressManager.getInstance().run((Task)new PackageInstaller(this.myProject, this.myInterpreter, repoPackage.getName(), version, new File(baseDir.getPath()), listener, extraOptions));
    }

    public void installPackage(RepoPackage repoPackage, @Nullable String version, @Nullable String extraOptions, PackageManagementService.Listener listener, @NotNull File workingDir) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/jetbrains/nodejs/packages/NodePackageManagementService", "installPackage"));
        }
        UsageTrigger.trigger((String)"Npm.Packages.Install.Package");
        ProgressManager.getInstance().run((Task)new PackageInstaller(this.myProject, this.myInterpreter, repoPackage.getName(), version, workingDir, listener, extraOptions));
    }

    public void uninstallPackages(List<InstalledPackage> installedPackages, PackageManagementService.Listener listener) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (InstalledPackage installedPackage : installedPackages) {
                if (!(installedPackage instanceof NodeInstalledPackage)) continue;
                this.uninstallPackage((NodeInstalledPackage)installedPackage, listener);
            }
        });
    }

    private void uninstallPackage(@NotNull NodeInstalledPackage installedPackage, @NotNull PackageManagementService.Listener listener) {
        if (installedPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedPackage", "com/jetbrains/nodejs/packages/NodePackageManagementService", "uninstallPackage"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/packages/NodePackageManagementService", "uninstallPackage"));
        }
        ArrayList args = ContainerUtil.newArrayList();
        if (installedPackage.isGlobal()) {
            args.add("-g");
        }
        args.add(NpmCommand.UNINSTALL.getCliOption(this.myInterpreter.isYarnAlikePackage()));
        args.add(installedPackage.getName());
        this.runNpmCommand(installedPackage.getName(), installedPackage, args, listener);
    }

    public void fetchPackageVersions(String packageName, final CatchingConsumer<List<String>, Exception> consumer) {
        this.myManager.fetchPackageInfo(new NodePackageInfoManager.PackageInfoConsumer(packageName){

            @Override
            public void onPackageInfo(@Nullable NodePackageInfo packageInfo) {
                if (packageInfo != null) {
                    consumer.consume(packageInfo.getVersions());
                }
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/packages/NodePackageManagementService$1", "onException"));
                }
                consumer.consume((Throwable)e);
            }
        });
    }

    public void fetchPackageDetails(String packageName, final CatchingConsumer<String, Exception> consumer) {
        this.myManager.fetchPackageInfo(new NodePackageInfoManager.PackageInfoConsumer(packageName){

            @Override
            public void onPackageInfo(@Nullable NodePackageInfo packageInfo) {
                if (packageInfo != null) {
                    consumer.consume((Object)packageInfo.formatHtmlDescription());
                }
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/packages/NodePackageManagementService$2", "onException"));
                }
                if (e instanceof NodePackageInfoException) {
                    NodePackageInfoException infoException = (NodePackageInfoException)e;
                    consumer.consume((Object)infoException.formatHtmlDescription());
                }
                consumer.consume((Throwable)e);
            }
        });
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version, @NotNull PackageManagementService.Listener listener) {
        if (installedPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedPackage", "com/jetbrains/nodejs/packages/NodePackageManagementService", "updatePackage"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/packages/NodePackageManagementService", "updatePackage"));
        }
        NodeInstalledPackage pkg = (NodeInstalledPackage)((Object)ObjectUtils.tryCast((Object)installedPackage, NodeInstalledPackage.class));
        if (pkg == null) {
            return;
        }
        ArrayList args = ContainerUtil.newArrayList();
        boolean yarn = this.myInterpreter.isYarnAlikePackage();
        NpmCommand command = yarn ? NpmCommand.UPDATE : NpmCommand.INSTALL;
        args.add(command.getCliOption(yarn));
        args.add(pkg.getName() + (version != null ? "@" + version : ""));
        this.runNpmCommand(pkg.getName(), pkg, args, listener);
        UsageTrigger.trigger((String)"Npm.Packages.Update.Package");
    }

    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, final @NotNull CatchingConsumer<String, Exception> consumer) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/jetbrains/nodejs/packages/NodePackageManagementService", "fetchLatestVersion"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/packages/NodePackageManagementService", "fetchLatestVersion"));
        }
        String packageName = pkg.getName();
        this.myManager.fetchPackageInfo(new NodePackageInfoManager.PackageInfoConsumer(packageName, false){

            @Override
            public void onPackageInfo(@Nullable NodePackageInfo packageInfo) {
                if (packageInfo != null) {
                    consumer.consume((Object)packageInfo.getLatestVersion());
                } else {
                    consumer.consume((Object)null);
                }
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/packages/NodePackageManagementService$3", "onException"));
                }
                consumer.consume((Throwable)e);
            }
        });
    }

    @Nullable
    private File guessWorkingDir(@Nullable NodeInstalledPackage pkg) {
        VirtualFile baseDir;
        if (pkg != null) {
            File workingDir = pkg.getSourceRootDir().getParentFile();
            if (workingDir != null && workingDir.getName().equals("node_modules")) {
                workingDir = workingDir.getParentFile();
            }
            if (workingDir != null) {
                return workingDir;
            }
        }
        return (baseDir = this.myProject.getBaseDir()) != null ? VfsUtilCore.virtualToIoFile((VirtualFile)baseDir) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNpmCommand(@NotNull String packageName, @Nullable NodeInstalledPackage pkg, @NotNull List<String> args, @NotNull PackageManagementService.Listener listener) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageManagementService", "runNpmCommand"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/nodejs/packages/NodePackageManagementService", "runNpmCommand"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/packages/NodePackageManagementService", "runNpmCommand"));
        }
        File workingDir = this.guessWorkingDir(pkg);
        if (workingDir == null) {
            String message = "Cannot determine working directory for " + packageName + ": " + args;
            LOG.warn(message);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/packages/NodePackageManagementService", "lambda$runNpmCommand$3"));
                }
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageManagementService", "lambda$runNpmCommand$3"));
                }
                listener.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)message));
            }, ModalityState.any());
            return;
        }
        GeneralCommandLine commandLine = (GeneralCommandLine)PackageInstaller.computeAndReportIfFailed((PackageManagementService.Listener)listener, (String)packageName, () -> {
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/jetbrains/nodejs/packages/NodePackageManagementService", "lambda$runNpmCommand$4"));
            }
            return NodeCommandLineUtil.createNpmCommandLine((File)workingDir, (NodeJsLocalInterpreter)this.myInterpreter, (List)args);
        });
        if (commandLine == null) {
            return;
        }
        Ref errorMessageRef = Ref.create();
        try {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/packages/NodePackageManagementService", "lambda$runNpmCommand$5"));
                }
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageManagementService", "lambda$runNpmCommand$5"));
                }
                listener.operationStarted(packageName);
            }, ModalityState.any());
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = processHandler.runProcess();
            if (output.getExitCode() != 0) {
                errorMessageRef.set((Object)NodeCommandLineUtil.formatErrorMessage((GeneralCommandLine)commandLine, (ProcessOutput)output));
            }
        }
        catch (ExecutionException e) {
            errorMessageRef.set((Object)e.getMessage());
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/packages/NodePackageManagementService", "lambda$runNpmCommand$6"));
                }
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageManagementService", "lambda$runNpmCommand$6"));
                }
                listener.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)((String)errorMessageRef.get())));
                LocalFileSystem.getInstance().refresh(true);
            }, ModalityState.any());
        }
    }
}

