/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.nodejs.packages.NodeInstalledPackagesPanel;
import com.jetbrains.nodejs.packages.NodePackageManagementService;
import com.jetbrains.nodejs.settings.NodeVersionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackagesView
implements NodeVersionListener {
    private final NodeInstalledPackagesPanel myPackagesPanel;
    private final JPanel myComponent;
    private final Project myProject;
    private NodeJsLocalInterpreter myCurrentInterpreter;

    public NodePackagesView(@NotNull Project project, boolean singleDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/packages/NodePackagesView", "<init>"));
        }
        this.myProject = project;
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Packages", (boolean)false));
        PackagesNotificationPanel packagesNotificationPanel = new PackagesNotificationPanel();
        this.myPackagesPanel = new NodeInstalledPackagesPanel(project, packagesNotificationPanel, singleDialog);
        panel.add((Component)((Object)this.myPackagesPanel), "Center");
        panel.add((Component)packagesNotificationPanel.getComponent(), "South");
        this.myComponent = panel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackagesView", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void versionUpdateStarted() {
        this.setNodeInterpreter(null);
    }

    @Override
    public void versionUpdated(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer version) {
        this.setNodeInterpreter(version != null ? NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter) : null);
    }

    private void setNodeInterpreter(@Nullable NodeJsLocalInterpreter interpreter) {
        boolean equals;
        boolean bl = interpreter == null ? this.myCurrentInterpreter == null : (equals = interpreter.deepEquals((NodeJsInterpreter)this.myCurrentInterpreter));
        if (!equals) {
            this.myCurrentInterpreter = interpreter;
            NodePackageManagementService service = null;
            if (interpreter != null) {
                service = new NodePackageManagementService(this.myProject, interpreter);
            }
            this.myPackagesPanel.updatePackages((PackageManagementService)service);
        }
    }
}

