/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeJSRemoteSdkCredentials;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkCredentialsHolder;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSRemoteSdkAdditionalData
implements RemoteSdkAdditionalData<NodeJSRemoteSdkCredentials> {
    public static final String HELPERS_DIR = ".webstorm_nodejs_helpers";
    private static final String VERSION = "VERSION";
    private final RemoteConnectionCredentialsWrapper myRemoteConnectionCredentialsWrapper;
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties;
    private String myVersionString;

    public NodeJSRemoteSdkAdditionalData() {
        this.myRemoteConnectionCredentialsWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(HELPERS_DIR);
    }

    public NodeJSRemoteSdkAdditionalData(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData", "<init>"));
        }
        this.myRemoteConnectionCredentialsWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(HELPERS_DIR);
        this.setInterpreterPath(interpreterPath);
    }

    private RemoteSdkCredentialsProducer<NodeJSRemoteSdkCredentials> getProducer() {
        NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
        if (manager != null) {
            return manager.getRemoteSdkCredentialsProducer((Function)new Function<RemoteCredentials, NodeJSRemoteSdkCredentials>(){

                public NodeJSRemoteSdkCredentials apply(RemoteCredentials credentials) {
                    return NodeJSRemoteSdkAdditionalData.this.createRemoteCredentials(credentials);
                }
            }, this.myRemoteConnectionCredentialsWrapper);
        }
        throw new IllegalStateException(NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
    }

    private NodeJSRemoteSdkCredentials createRemoteCredentials(RemoteCredentials credentials) {
        NodeJSRemoteSdkCredentialsHolder holder = new NodeJSRemoteSdkCredentialsHolder(this.myRemoteSdkProperties);
        RemoteSdkCredentialsBuilder.copyCredentials((RemoteCredentials)credentials, (MutableRemoteCredentials)holder);
        return holder;
    }

    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    public void addRemoteRoot(String remoteRoot) {
        this.myRemoteSdkProperties.addRemoteRoot(remoteRoot);
    }

    public void clearRemoteRoots() {
        this.myRemoteSdkProperties.clearRemoteRoots();
    }

    public List<String> getRemoteRoots() {
        return this.myRemoteSdkProperties.getRemoteRoots();
    }

    public void setRemoteRoots(List<String> remoteRoots) {
        this.myRemoteSdkProperties.setRemoteRoots(remoteRoots);
    }

    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myRemoteSdkProperties.getPathMappings();
        if (pathMappingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData", "getPathMappings"));
        }
        return pathMappingSettings;
    }

    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myRemoteSdkProperties.setPathMappings(pathMappings);
    }

    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    public void setSdkId(String sdkId) {
        throw new IllegalStateException("sdkId in this class is constructed based on fields, so it can't be set");
    }

    public String getSdkId() {
        return NodeJSRemoteSdkAdditionalData.constructSdkID(this.myRemoteConnectionCredentialsWrapper, this.myRemoteSdkProperties);
    }

    private static String constructSdkID(@NotNull RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper, @NotNull RemoteSdkPropertiesHolder properties) {
        if (remoteConnectionCredentialsWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteConnectionCredentialsWrapper", "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData", "constructSdkID"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData", "constructSdkID"));
        }
        return remoteConnectionCredentialsWrapper.getId() + properties.getInterpreterPath();
    }

    public void completeInitialization() {
    }

    public boolean isInitialized() {
        return this.myRemoteSdkProperties.isInitialized();
    }

    public void setInitialized(boolean initialized) {
        this.myRemoteSdkProperties.setInitialized(initialized);
    }

    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    public void setValid(boolean valid) {
        this.myRemoteSdkProperties.setValid(valid);
    }

    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        return this.myRemoteConnectionCredentialsWrapper;
    }

    public NodeJSRemoteSdkCredentials getRemoteSdkCredentials() throws InterruptedException, ExecutionException {
        return (NodeJSRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials();
    }

    public NodeJSRemoteSdkCredentials getRemoteSdkCredentials(boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return (NodeJSRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials(allowSynchronousInteraction);
    }

    public NodeJSRemoteSdkCredentials getRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return (NodeJSRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials(allowSynchronousInteraction);
    }

    public void produceRemoteSdkCredentials(boolean allowSynchronousInteraction, @NotNull Consumer<NodeJSRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkCredentialsConsumer", "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData", "produceRemoteSdkCredentials"));
        }
        this.getProducer().produceRemoteSdkCredentials(allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction, Consumer<NodeJSRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(Consumer<NodeJSRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(remoteSdkCredentialsConsumer);
    }

    public Object getRemoteSdkDataKey() {
        return this.myRemoteConnectionCredentialsWrapper.getConnectionKey();
    }

    public static IllegalStateException unknownConnectionType() {
        return RemoteConnectionCredentialsWrapper.unknownConnectionType();
    }

    public NodeJSRemoteSdkAdditionalData clone() throws CloneNotSupportedException {
        NodeJSRemoteSdkAdditionalData copy = new NodeJSRemoteSdkAdditionalData(this.myRemoteSdkProperties.getInterpreterPath());
        this.copyTo(copy);
        return copy;
    }

    public void copyTo(NodeJSRemoteSdkAdditionalData copy) {
        copy.setVersionString(this.myVersionString);
        this.myRemoteSdkProperties.copyTo((RemoteSdkProperties)copy.myRemoteSdkProperties);
        this.myRemoteConnectionCredentialsWrapper.copyTo(copy.myRemoteConnectionCredentialsWrapper);
    }

    public void save(Element rootElement) {
        this.myRemoteConnectionCredentialsWrapper.save(rootElement);
        this.myRemoteSdkProperties.save(rootElement);
        rootElement.setAttribute(VERSION, StringUtil.notNullize((String)this.getVersionString()));
    }

    public static NodeJSRemoteSdkAdditionalData load(@Nullable Element element, @NotNull String interpreterPath) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData", "load"));
        }
        String fullPath = RemoteSdkCredentialsHolder.getInterpreterPathFromFullPath((String)interpreterPath);
        NodeJSRemoteSdkAdditionalData data = new NodeJSRemoteSdkAdditionalData(fullPath);
        if (element != null) {
            CredentialsManager.getInstance().loadCredentials(interpreterPath, element, (RemoteSdkAdditionalData)data);
            data.myRemoteSdkProperties.load(element);
            data.setVersionString(StringUtil.notNullize((String)element.getAttributeValue(VERSION)));
        }
        return data;
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myRemoteConnectionCredentialsWrapper.setCredentials(key, credentials);
    }

    public CredentialsType getRemoteConnectionType() {
        return this.myRemoteConnectionCredentialsWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases) {
        this.myRemoteConnectionCredentialsWrapper.switchType(cases);
    }

    public String getVersionString() {
        return this.myVersionString;
    }

    public void setVersionString(String versionString) {
        this.myVersionString = versionString;
    }
}

