/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRunConfigurationRefactoringHandler {
    @Nullable
    public static RefactoringElementListener createRefactoringElementListener(@NotNull NodeJsRunConfiguration configuration, @Nullable PsiElement element) {
        VirtualFile elementVirtualFile;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler", "createRefactoringElementListener"));
        }
        if (element != null && (elementVirtualFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null) {
            String workingDirectoryRelativePath = NodeJsRunConfigurationRefactoringHandler.getWorkingDirectoryRelativePath(configuration, elementVirtualFile);
            String inputFileRelativePath = NodeJsRunConfigurationRefactoringHandler.getInputFileRelativePath(configuration, elementVirtualFile);
            if (workingDirectoryRelativePath != null || inputFileRelativePath != null) {
                return new NodeRcRefactoringElementListener(configuration, workingDirectoryRelativePath, inputFileRelativePath);
            }
        }
        return null;
    }

    @Nullable
    private static String getWorkingDirectoryRelativePath(@NotNull NodeJsRunConfiguration configuration, @NotNull VirtualFile refactoredDir) {
        VirtualFile workingDirectory;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler", "getWorkingDirectoryRelativePath"));
        }
        if (refactoredDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactoredDir", "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler", "getWorkingDirectoryRelativePath"));
        }
        String workingDirectoryPath = configuration.getWorkingDirectory();
        if (!workingDirectoryPath.isEmpty() && (workingDirectory = LocalFileSystem.getInstance().findFileByPath(workingDirectoryPath)) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)workingDirectory, (VirtualFile)refactoredDir);
        }
        return null;
    }

    @Nullable
    private static String getInputFileRelativePath(@NotNull NodeJsRunConfiguration configuration, @NotNull VirtualFile refactoredFile) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler", "getInputFileRelativePath"));
        }
        if (refactoredFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactoredFile", "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler", "getInputFileRelativePath"));
        }
        VirtualFile inputFile = DebuggableProcessRunConfigurationBase.findInputVirtualFile((DebuggableProcessRunConfiguration)configuration);
        if (inputFile != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)inputFile, (VirtualFile)refactoredFile);
        }
        return null;
    }

    private static class NodeRcRefactoringElementListener
    extends UndoRefactoringElementAdapter {
        private final NodeJsRunConfiguration myConfiguration;
        private final String myWorkingDirectoryRelativePath;
        private final String myInputFileRelativePath;

        public NodeRcRefactoringElementListener(@NotNull NodeJsRunConfiguration configuration, @Nullable String workingDirectoryRelativePath, @Nullable String inputFileRelativePath) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler$NodeRcRefactoringElementListener", "<init>"));
            }
            this.myConfiguration = configuration;
            this.myWorkingDirectoryRelativePath = workingDirectoryRelativePath;
            this.myInputFileRelativePath = inputFileRelativePath;
        }

        protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/run/NodeJsRunConfigurationRefactoringHandler$NodeRcRefactoringElementListener", "refactored"));
            }
            VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
            if (newFile != null) {
                VirtualFile inputFile;
                VirtualFile workingDirectory;
                if (this.myWorkingDirectoryRelativePath != null && (workingDirectory = newFile.findFileByRelativePath(this.myWorkingDirectoryRelativePath)) != null) {
                    this.myConfiguration.setWorkingDirectory(workingDirectory.getPath());
                }
                if (this.myInputFileRelativePath != null && (inputFile = newFile.findFileByRelativePath(this.myInputFileRelativePath)) != null) {
                    this.myConfiguration.setInputPath(inputFile.getPath());
                }
            }
        }
    }
}

