/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.jetbrains.nodejs.run.profile.TreeTableWithTreeWidthController;
import com.jetbrains.nodejs.run.profile.V8Utils;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;

public class TreeTableWidthController {
    private final TreeTableWithTreeWidthController myTreeTable;
    private final List<Integer> myTailWidths;
    private int myRightMin;
    private final ZipperUpdater myUpdater;
    private int myCurrentZeroWidth;
    private TreeCellRenderer myMeaningfulRenderer;
    private TreeExpansionListener myExpansionListener;
    private int myCachedWidth;
    private Runnable myRecalculateRunnable;

    public TreeTableWidthController(TreeTableWithTreeWidthController treeTable, @NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/nodejs/run/profile/TreeTableWidthController", "<init>"));
        }
        this.myCachedWidth = -1;
        this.myTreeTable = treeTable;
        this.myTailWidths = new ArrayList<Integer>();
        this.recalculateTail();
        this.myRecalculateRunnable = () -> {
            this.myCachedWidth = -1;
            this.recalculateImpl();
        };
        this.myUpdater = new ZipperUpdater(100, Alarm.ThreadToUse.SWING_THREAD, disposable);
        this.recalculateZero();
        this.installListener();
    }

    private void recalculateTail() {
        TableColumnModel model = this.myTreeTable.getColumnModel();
        int width = 0;
        for (int i = 1; i < model.getColumnCount(); ++i) {
            int tailWidth = model.getColumn(i).getMinWidth();
            this.myTailWidths.add(tailWidth);
            width += tailWidth;
        }
        this.myRightMin = width;
    }

    public void recalculateAll() {
        this.recalculateTail();
        this.myCachedWidth = -1;
        this.recalculateZero();
    }

    public void setMeaningfulRenderer(TreeCellRenderer meaningfulRenderer) {
        this.myMeaningfulRenderer = meaningfulRenderer;
        this.recalculateZero();
    }

    public int getWidth(int parentWidth) {
        if (this.myCachedWidth > 0) {
            return this.myCachedWidth;
        }
        TableColumnModel model = this.myTreeTable.getColumnModel();
        TableColumn zero = model.getColumn(0);
        if (this.myCurrentZeroWidth + this.myRightMin < parentWidth) {
            int width = 0;
            for (int i = 1; i < model.getColumnCount(); ++i) {
                int colWidth = this.myTailWidths.get(i - 1);
                width += colWidth;
                model.getColumn(i).setMinWidth(colWidth);
                model.getColumn(i).setWidth(colWidth);
            }
            int zeroWidth = parentWidth - width;
            zero.setMinWidth(zeroWidth);
            zero.setWidth(zeroWidth);
            return parentWidth;
        }
        zero.setMinWidth(this.myCurrentZeroWidth);
        zero.setWidth(this.myCurrentZeroWidth);
        for (int i = 1; i < model.getColumnCount(); ++i) {
            Integer width = this.myTailWidths.get(i - 1);
            model.getColumn(i).setMinWidth(width);
            model.getColumn(i).setWidth(width);
        }
        return this.myCurrentZeroWidth + this.myRightMin;
    }

    public void startBatchExpand() {
        this.myCachedWidth = this.getWidth(this.myTreeTable.getParent().getWidth());
        this.myTreeTable.getTree().removeTreeExpansionListener(this.myExpansionListener);
    }

    public void stopBatchExpand() {
        this.myTreeTable.getTree().addTreeExpansionListener(this.myExpansionListener);
        this.myCachedWidth = -1;
        this.recalculateZero();
    }

    public void installListener() {
        if (this.myExpansionListener != null) {
            this.myTreeTable.getTree().removeTreeExpansionListener(this.myExpansionListener);
        }
        this.myExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableWidthController.this.recalculateZero();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableWidthController.this.recalculateZero();
            }
        };
        this.myTreeTable.getTree().addTreeExpansionListener(this.myExpansionListener);
        this.recalculateZero();
    }

    private void adjustColumn() {
        TableColumn column = this.myTreeTable.getColumnModel().getColumn(0);
        column.setMinWidth(this.myCurrentZeroWidth);
        column.setWidth(this.myCurrentZeroWidth);
    }

    private void recalculateZero() {
        this.myUpdater.queue(this.myRecalculateRunnable);
    }

    private void recalculateImpl() {
        int max = 0;
        int count = this.myTreeTable.getRowCount();
        TreeTableTree tree = this.myTreeTable.getTree();
        TreeCellRenderer renderer = this.myMeaningfulRenderer != null ? this.myMeaningfulRenderer : tree.getCellRenderer();
        for (int i = 0; i < count; ++i) {
            int width = this.getRowWidth(renderer, i);
            max = Math.max(width, max);
        }
        this.myCurrentZeroWidth = max;
        this.adjustColumn();
    }

    private int getRowWidth(TreeCellRenderer renderer, int i) {
        int width;
        TreeTableTree tree = this.myTreeTable.getTree();
        Object component = tree.getPathForRow(i).getLastPathComponent();
        if (renderer instanceof SimpleColoredComponent) {
            renderer.getTreeCellRendererComponent((JTree)tree, component, true, true, false, i, false);
            Dimension size = ((SimpleColoredComponent)renderer).computePreferredSize(false);
            int rowX = V8Utils.getTableRowX((JTree)tree, i);
            width = rowX + size.width;
        } else {
            double approxWidth = (double)tree.getFontMetrics(tree.getFont()).stringWidth(component.toString()) * 1.1;
            int rowX = V8Utils.getTableRowX((JTree)tree, i);
            width = rowX + (int)approxWidth;
        }
        return width;
    }
}

