/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModelAdapter;
import com.intellij.util.Alarm;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeTableWithTreeWidthController
extends TreeTable {
    @NotNull
    private final Disposable myDisposable;
    private final ZipperUpdater myUpdater;

    public TreeTableWithTreeWidthController(TreeTableModel treeTableModel, @NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/nodejs/run/profile/TreeTableWithTreeWidthController", "<init>"));
        }
        super(treeTableModel);
        this.myDisposable = disposable;
        this.myUpdater = new ZipperUpdater(100, Alarm.ThreadToUse.SWING_THREAD, disposable);
    }

    @Nullable
    public abstract TreeTableWidthController getWidthController();

    protected TreeTableModelAdapter adapt(TreeTableModel treeTableModel) {
        return new TreeTableModelAdapter(treeTableModel, (JTree)this.getTree(), (JTable)((Object)this)){
            private final Runnable myDelegate;
            {
                this.myDelegate = () -> this.delayedFireTableDataChangedImpl();
            }

            private void delayedFireTableDataChangedImpl() {
                super.fireTableDataChanged();
            }

            public void fireTableDataChanged() {
                TreeTableWithTreeWidthController.this.myUpdater.queue(this.myDelegate);
            }

            protected void delayedFireTableDataChanged() {
                TreeTableWithTreeWidthController.this.myUpdater.queue(this.myDelegate);
            }
        };
    }
}

