/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.TreeTableWithTreeWidthController;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.TableWithFixedWidth;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8Utils {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.V8Utils");
    public static final DataKey<Long> DETAILS_POSITION = DataKey.create((String)"V8.CPU.DETAILS_POSITION");
    public static final DataKey<Boolean> IS_NAVIGATABLE = DataKey.create((String)"V8.IS.NAVIGATABLE");
    public static final DataKey<Navigatable[]> NAVIGATABLE_ONLY_FOR_ACTION = DataKey.create((String)"V8.NAVIGATABLE_ONLY_FOR_ACTION");
    public static final DataKey<Pair<Integer, Integer>> NAVIGATION_POSITION = DataKey.create((String)"V8.NAVIGATION_POSITION");
    public static final DataKey<V8CpuLogCall> SELECTED_CALL = DataKey.create((String)"V8.SELECTED_CALL");
    @NonNls
    public static final String HEAPSNAPSHOT = "heapsnapshot";
    private static Navigatable[] ourEmptyNavigatables = new Navigatable[]{new Navigatable(){

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }
    }};
    private static final String[] UNIX_PATH = new String[]{"/usr/bin/gnuplot", " /usr/local/bin/gnuplot"};

    public static void selectAndNavigate(AnActionEvent e, List<Navigatable> navigatables, Consumer<Navigatable> consumer, final @Nullable Map<Navigatable, String> addText) {
        JBList list = new JBList();
        DefaultListModel<Navigatable> model = new DefaultListModel<Navigatable>();
        list.setModel(model);
        for (int i = 0; i < navigatables.size(); ++i) {
            Navigatable item = navigatables.get(i);
            model.add(i, item);
        }
        list.setCellRenderer((ListCellRenderer)new DefaultPsiElementCellRenderer(){

            public String getContainerText(PsiElement element, String name) {
                String text = super.getContainerText(element, name);
                String add = addText == null ? "" : (String)addText.get(element);
                return add == null ? text : text + add;
            }
        });
        PopupChooserBuilder popupChooserBuilder = new PopupChooserBuilder((JList)list).setTitle("Select file to navigate to:").setMovable(true).setResizable(true).setCancelKeyEnabled(true).setCancelOnWindowDeactivation(true).setCancelOnClickOutside(true).setItemChoosenCallback(() -> {
            int[] ids = list.getSelectedIndices();
            if (ids.length != 1) {
                return;
            }
            Navigatable item = (Navigatable)list.getModel().getElementAt(ids[0]);
            consumer.consume((Object)item);
        });
        JBPopup popup = popupChooserBuilder.createPopup();
        V8Utils.showPopup(e, popup);
    }

    public static Point showPopup(AnActionEvent e, JBPopup popup) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.getXOnScreen() == 0 && mouseEvent.getYOnScreen() == 0) {
                popup.showInBestPositionFor(e.getDataContext());
                return popup.getLocationOnScreen();
            }
            popup.show(new RelativePoint(mouseEvent));
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
        return popup.getLocationOnScreen();
    }

    public static JComponent wrapWithActions(@NotNull JComponent pane, @NotNull DefaultActionGroup group) {
        if (pane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pane", "com/jetbrains/nodejs/run/profile/V8Utils", "wrapWithActions"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/jetbrains/nodejs/run/profile/V8Utils", "wrapWithActions"));
        }
        return new WithToolbarWrapper(pane, group).getMainPanel();
    }

    public static void adjustTableColumnWidths(TableWithFixedWidth table) {
        TableModel model = table.getModel();
        table.setAutoResizeMode(0);
        int columnCount = table.getColumnCount();
        FontMetrics metrics = table.getFontMetrics(table.getTableHeader().getFont());
        int rowCount = model.getRowCount();
        int total = 0;
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            int maxWidth = metrics.stringWidth(column.getHeaderValue().toString()) + 2;
            for (int j = 0; j < rowCount; ++j) {
                TableCellRenderer renderer = table.getCellRenderer(j, i);
                renderer.getTableCellRendererComponent((JTable)((Object)table), model.getValueAt(j, i), false, false, j, i);
                if (!(renderer instanceof ColoredTableCellRenderer)) continue;
                maxWidth = Math.max(((ColoredTableCellRenderer)renderer).computePreferredSize((boolean)false).width + 2, maxWidth);
            }
            total += maxWidth;
            if (i == 0) {
                column.setMinWidth(maxWidth);
                continue;
            }
            V8Utils.fixColumnWidth(maxWidth, column);
        }
        table.setMinWidth(total);
    }

    public static void collapseAll(TreeTable treeTable) {
        TreeTableTree tree = treeTable.getTree();
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        V8Utils.collapseAllBare(treeTable);
        Object root = tree.getModel().getRoot();
        tree.expandPath(new TreePath(root));
        if (leadSelectionPath != null && leadSelectionPath.getPath().length > 1) {
            TreeUtil.selectPath((JTree)tree, (TreePath)new TreePath(Arrays.copyOf(leadSelectionPath.getPath(), 2)));
        }
    }

    public static void collapseAllBare(TreeTable treeTable) {
        TreeTableTree tree = treeTable.getTree();
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
    }

    public static void setSmallerTreeIndent(TreeTableTree tree) {
        TreeUI ui = tree.getUI();
        if (ui instanceof BasicTreeUI) {
            BasicTreeUI basicUi = (BasicTreeUI)ui;
            basicUi.setRightChildIndent(UIUtil.getTreeRightChildIndent() / 2);
        }
    }

    @NotNull
    public static String formatPercent(int percent) {
        if (percent == 0) {
            if ("0%" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/V8Utils", "formatPercent"));
            }
            return "0%";
        }
        String string = new Formatter().format("%.1f%%", (double)percent / 10.0).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/V8Utils", "formatPercent"));
        }
        return string;
    }

    public static int tensPercent(long ticks, long totalTicks) {
        return V8Utils.tensPercent((int)ticks, (int)totalTicks);
    }

    public static int tensPercent(int ticks, int totalTicks) {
        return (int)Math.round((double)ticks * 1000.0 / (double)totalTicks);
    }

    public static void installHeapPopupMenu(Project project, @NotNull TreeTable treeTable, @NotNull V8CachingReader reader, V8MainTreeNavigator navigator) {
        if (treeTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeTable", "com/jetbrains/nodejs/run/profile/V8Utils", "installHeapPopupMenu"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/V8Utils", "installHeapPopupMenu"));
        }
        DefaultActionGroup group = new DefaultActionGroup();
        MarkUnmarkAction markUnmarkAction = new MarkUnmarkAction(project, reader);
        markUnmarkAction.setTable(treeTable);
        group.add((AnAction)markUnmarkAction);
        if (navigator != null) {
            V8NavigateToMainTreeAction action = new V8NavigateToMainTreeAction();
            action.setFixedNavigator(navigator);
            action.setTable(treeTable);
            group.add((AnAction)action);
        }
        group.add((AnAction)new GoToSourceAction(reader, treeTable));
        PopupHandler.installPopupHandler((JComponent)treeTable, (ActionGroup)group, (String)"V8_HEAP_PROFILING_POPUP", (ActionManager)ActionManager.getInstance());
    }

    public static String encodeUrl(@NotNull String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/nodejs/run/profile/V8Utils", "encodeUrl"));
        }
        try {
            URL urlUrl = new URL(url);
            URI uri = new URI(urlUrl.getProtocol(), urlUrl.getUserInfo(), urlUrl.getHost(), urlUrl.getPort(), urlUrl.getPath(), urlUrl.getQuery(), urlUrl.getRef());
            return uri.toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static int getTableRowX(@NotNull JTree tree, int row) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/nodejs/run/profile/V8Utils", "getTableRowX"));
        }
        return TableRowXReflectionHolder.getRowX(tree, row);
    }

    public static V8HeapTreeTable createTable(Project project, TreeTableModel model, V8CachingReader reader) {
        V8HeapTreeTable table = new V8HeapTreeTable(model, reader.getResourses());
        V8Utils.afterModelReset(project, reader, table);
        return table;
    }

    public static void afterModelReset(Project project, V8CachingReader reader, V8HeapTreeTable table) {
        String sample = String.valueOf(reader.getRetainedSize(0)) + " 100% a b";
        V8Utils.afterModelReset(table, sample, reader.getResourses(), (TreeCellRenderer)((Object)new DirectTreeTableRenderer(project, reader)));
    }

    public static void afterModelReset(V8HeapTreeTable table, @Nullable String sample, CompositeCloseable resources, TreeCellRenderer renderer) {
        table.setAutoResizeMode(0);
        table.getTableHeader().setResizingAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRootVisible(false);
        table.getTree().setShowsRootHandles(true);
        table.smallerIndent();
        table.setSelectionMode(0);
        V8Utils.adjustColumnWIdths(table, sample);
        table.attachWidthController(resources, renderer);
    }

    public static void adjustColumnWIdths(TreeTable table, String sample) {
        block4: {
            int count;
            TableColumnModel model;
            FontMetrics metrics;
            block3: {
                metrics = table.getTableHeader().getFontMetrics(table.getTableHeader().getFont());
                model = table.getTableHeader().getColumnModel();
                count = table.getTableModel().getColumnCount();
                if (sample != null || !(table.getTableModel() instanceof TreeTableModelWithCustomRenderer)) break block3;
                TreeTableModelWithCustomRenderer withRenderer = (TreeTableModelWithCustomRenderer)table.getTableModel();
                for (int col = 1; col < count; ++col) {
                    TableColumn column = table.getColumnModel().getColumn(col);
                    int maxWidth = metrics.stringWidth(column.getHeaderValue().toString()) + 2;
                    for (int row = 0; row < table.getRowCount(); ++row) {
                        Object value = table.getValueAt(row, col);
                        ColoredTableCellRenderer renderer = (ColoredTableCellRenderer)withRenderer.getCustomizedRenderer(col, value, table.getCellRenderer(row, col));
                        renderer.getTableCellRendererComponent((JTable)table, value, false, true, row, col);
                        maxWidth = Math.max(renderer.computePreferredSize((boolean)false).width + 10, maxWidth);
                    }
                    V8Utils.fixColumnWidth(maxWidth, column);
                }
                break block4;
            }
            if (sample == null) break block4;
            int width = Math.max(metrics.stringWidth(sample) + 3, 10);
            for (int i = 1; i < count; ++i) {
                V8Utils.fixColumnWidth(width, model.getColumn(i));
            }
        }
    }

    public static void fixColumnWidth(int width, TableColumn two) {
        two.setWidth(width);
        two.setMaxWidth(4 * width);
        two.setMinWidth(width);
    }

    public static void writeIntList(TIntArrayList list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            out.writeInt(list.get(i));
        }
    }

    public static TIntArrayList readIntList(ObjectInput in) throws IOException {
        int size = in.readInt();
        TIntArrayList list = new TIntArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeDraw(@NotNull Graphics2D graphics2D, Consumer<Graphics2D> consumer) {
        if (graphics2D == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics2D", "com/jetbrains/nodejs/run/profile/V8Utils", "safeDraw"));
        }
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        try {
            consumer.consume((Object)graphics2D);
        }
        finally {
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.setFont(font);
        }
    }

    private static class TableRowXReflectionHolder {
        private static Method ourMethod;

        private TableRowXReflectionHolder() {
        }

        public static int getRowX(@NotNull JTree tree, int row) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/nodejs/run/profile/V8Utils$TableRowXReflectionHolder", "getRowX"));
            }
            if (tree instanceof TreeTableTree && ourMethod != null) {
                TreeUI ui = tree.getUI();
                try {
                    TreePath pathForRow = tree.getPathForRow(row);
                    if (pathForRow != null) {
                        return (Integer)ourMethod.invoke((Object)ui, row, pathForRow.getPath().length);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return 0;
        }

        static {
            try {
                Class<?> aClass = Class.forName("javax.swing.plaf.basic.BasicTreeUI");
                ourMethod = aClass.getDeclaredMethod("getRowX", Integer.TYPE, Integer.TYPE);
                ourMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.info("Problem: V8 profiling trees would not be able to render correctly: can not get access to tree table row indent: " + e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.info("Problem: V8 profiling trees would not be able to render correctly: can not get access to tree table row indent: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class CollapseAllAction
    extends DumbAwareAction {
        private TreeTable myTable;

        public CollapseAllAction(TreeTable table) {
            super("Collapse All", "Collapse All", AllIcons.Actions.Collapseall);
            this.myTable = table;
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("CollapseAll").getShortcutSet(), (JComponent)this.myTable);
        }

        public void setTable(TreeTableWithTreeWidthController table) {
            this.myTable = table;
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)this.myTable);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myTable != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myTable == null) {
                return;
            }
            V8Utils.collapseAll(this.myTable);
        }
    }

    public static class ExpandAllAction
    extends DumbAwareAction {
        private TreeTableWithTreeWidthController myTable;

        public ExpandAllAction(TreeTableWithTreeWidthController table) {
            super("Expand All", "Expand All", AllIcons.Actions.Expandall);
            this.myTable = table;
            if (this.myTable != null) {
                this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)((Object)this.myTable));
            }
        }

        public void setTable(TreeTableWithTreeWidthController table) {
            this.myTable = table;
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)((Object)this.myTable));
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myTable != null);
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myTable == null) {
                return;
            }
            TreeTableWidthController controller = this.myTable.getWidthController();
            if (controller != null) {
                controller.startBatchExpand();
            }
            TreeUtil.expandAll((JTree)this.myTable.getTree());
            if (controller != null) {
                controller.stopBatchExpand();
            }
        }
    }

    public static class LightweightEditSourceAction
    extends EditSourceAction {
        private final Component myComponent;

        public LightweightEditSourceAction(JComponent component) {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText(ActionsBundle.actionText((String)"EditSource").replace("_", ""));
            this.getTemplatePresentation().setDescription(ActionsBundle.actionDescription((String)"EditSource"));
            this.myComponent = component;
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), component);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            boolean enabled = project != null && Boolean.TRUE.equals(IS_NAVIGATABLE.getData(e.getDataContext()));
            e.getPresentation().setEnabled(enabled);
            if ("V8_CPU_PROFILING_POPUP".equals(e.getPlace())) {
                e.getPresentation().setVisible(enabled);
            }
        }

        @Nullable
        protected Navigatable[] getNavigatables(DataContext dataContext) {
            return ourEmptyNavigatables;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            Pair position = (Pair)NAVIGATION_POSITION.getData(e.getDataContext());
            Consumer consumer = item -> {
                if (item instanceof PsiFile && ((PsiFile)item).getVirtualFile() != null && position != null) {
                    new OpenFileDescriptor(project, ((PsiFile)item).getVirtualFile(), Math.max(0, (Integer)position.getFirst() - 1), Math.max(0, (Integer)position.getSecond() - 1)).navigate(true);
                    return;
                }
                item.navigate(true);
            };
            Navigatable[] navigatables = (Navigatable[])NAVIGATABLE_ONLY_FOR_ACTION.getData(e.getDataContext());
            if (navigatables == null || navigatables.length == 0) {
                NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("Cannot find declaration to go to", MessageType.INFO).notify(project);
                return;
            }
            if (navigatables.length == 1) {
                navigatables[0].navigate(true);
                return;
            }
            HashMap<Navigatable, String> addText = position == null ? null : new HashMap<Navigatable, String>();
            Navigatable first = null;
            if (position != null) {
                for (Navigatable navigatable : navigatables) {
                    if (navigatable instanceof PsiFile) {
                        addText.put(navigatable, ":" + position.getFirst() + ":" + position.getSecond());
                        continue;
                    }
                    if (!(navigatable instanceof PsiElement) || ((PsiElement)navigatable).getContainingFile() == null) continue;
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(((PsiElement)navigatable).getContainingFile());
                    int elemOffset = ((PsiElement)navigatable).getTextOffset();
                    int lineNumber = document.getLineNumber(elemOffset);
                    int column = elemOffset - document.getLineStartOffset(lineNumber);
                    boolean exact = lineNumber + 1 == (Integer)position.getFirst();
                    String comment = ":" + lineNumber + ":" + column;
                    if (exact) {
                        comment = ":" + (lineNumber + 1) + ":" + position.getSecond() + " (exact match)";
                        first = navigatable;
                    }
                    addText.put(navigatable, comment);
                }
            }
            final Navigatable finalFirst = first;
            Arrays.sort(navigatables, new Comparator<Navigatable>(){

                @Override
                public int compare(Navigatable o1, Navigatable o2) {
                    if (o1.equals(finalFirst)) {
                        return -1;
                    }
                    if (o2.equals(finalFirst)) {
                        return 1;
                    }
                    boolean isFile1 = o1 instanceof PsiFile;
                    boolean isFile2 = o2 instanceof PsiFile;
                    if (isFile1 != isFile2) {
                        return isFile1 ? 1 : -1;
                    }
                    return Comparing.compare((Comparable)((Object)this.getText(o1)), (Comparable)((Object)this.getText(o2)));
                }

                private String getText(Object o) {
                    if (o instanceof JSNamedElementBase) {
                        return ((JSNamedElementBase)o).getName();
                    }
                    if (o instanceof PsiFile) {
                        return ((PsiFile)o).getName();
                    }
                    return o.toString();
                }
            });
            V8Utils.selectAndNavigate(e, Arrays.asList(navigatables), (Consumer<Navigatable>)consumer, addText);
        }
    }

    public static class WithToolbarWrapper {
        private final JPanel myMainPanel;
        private final ActionToolbar myToolbar;

        public WithToolbarWrapper(@NotNull JComponent pane, @NotNull DefaultActionGroup group) {
            if (pane == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pane", "com/jetbrains/nodejs/run/profile/V8Utils$WithToolbarWrapper", "<init>"));
            }
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/jetbrains/nodejs/run/profile/V8Utils$WithToolbarWrapper", "<init>"));
            }
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myMainPanel.add((Component)pane, "Center");
            this.myToolbar = ActionManager.getInstance().createActionToolbar("V8 profiling", (ActionGroup)group, false);
            this.myMainPanel.add((Component)this.myToolbar.getComponent(), "West");
        }

        public JPanel getMainPanel() {
            return this.myMainPanel;
        }

        public ActionToolbar getToolbar() {
            return this.myToolbar;
        }
    }
}

