/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Parent;
import com.jetbrains.nodejs.run.profile.cpu.calculation.Chain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChainProcessor<T extends Parent<T>> {
    private final ArrayDeque<Chain<T>> myInput;
    private final List<Chain<T>> myRollUp;

    public ChainProcessor(List<Chain<T>> input) {
        this.myInput = new ArrayDeque<Chain<T>>(input);
        this.myRollUp = new ArrayList<Chain<T>>();
    }

    public List<Chain<T>> getRollUp() {
        return this.myRollUp;
    }

    public void process() {
        while (!this.myInput.isEmpty()) {
            Chain<T> chain = this.myInput.removeFirst();
            if (this.findOneLineRepeats(chain)) continue;
            this.findRepeats(chain);
        }
    }

    private void findRepeats(@NotNull Chain<T> chain) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/jetbrains/nodejs/run/profile/cpu/calculation/ChainProcessor", "findRepeats"));
        }
        HashMap<Pair, Integer> map = new HashMap<Pair, Integer>();
        Long previous = null;
        List<Long> ids = chain.getIds();
        for (int i = 0; i < ids.size(); ++i) {
            Long id = ids.get(i);
            if (previous != null) {
                Pair pair = Pair.create((Object)previous, (Object)id);
                Integer position = (Integer)map.get(pair);
                if (position != null && this.tryMatch(chain, position, i - 1)) {
                    return;
                }
                map.put(pair, i - 1);
            }
            previous = id;
        }
    }

    private boolean tryMatch(@NotNull Chain<T> chain, int start, int repeat) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/jetbrains/nodejs/run/profile/cpu/calculation/ChainProcessor", "tryMatch"));
        }
        int patternLen = repeat - start;
        if (patternLen <= 1) {
            return false;
        }
        int nextStart = start + 2 - patternLen;
        if (nextStart >= 0 && this.tryMatchFromIndex(chain, patternLen, nextStart)) {
            return true;
        }
        return nextStart != start && this.tryMatchFromIndex(chain, patternLen, start);
    }

    private boolean tryMatchFromIndex(@NotNull Chain<T> chain, int patternLen, int start) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/jetbrains/nodejs/run/profile/cpu/calculation/ChainProcessor", "tryMatchFromIndex"));
        }
        int firstStart = start;
        int successfulEnd = -1;
        while (start + patternLen <= chain.size() && this.patternMatch(chain, start, patternLen)) {
            successfulEnd = start + patternLen + patternLen;
            start += patternLen;
        }
        if (successfulEnd > 0) {
            List<Chain<T>> chains = chain.splitWithRollup(firstStart, successfulEnd, patternLen);
            Chain<T> last = chains.get(chains.size() - 1);
            if (!last.isRolled()) {
                this.myInput.add(last);
            }
            for (Chain<T> inner : chains) {
                if (!inner.isRolled()) continue;
                this.myRollUp.add(inner);
                break;
            }
            return true;
        }
        return false;
    }

    private boolean patternMatch(Chain<T> chain, int start, int len) {
        List<Long> ids = chain.getIds();
        if (start + len > ids.size() || start + len + len > ids.size()) {
            return false;
        }
        return ids.subList(start, start + len).equals(ids.subList(start + len, start + len + len));
    }

    private boolean findOneLineRepeats(@NotNull Chain<T> chain) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/jetbrains/nodejs/run/profile/cpu/calculation/ChainProcessor", "findOneLineRepeats"));
        }
        Long previous = null;
        int start = -1;
        for (int i = 0; i < chain.size(); ++i) {
            Long current = chain.get(i);
            if (current.equals(previous)) {
                if (start < 0) {
                    start = i - 1;
                }
            } else if (start >= 0) {
                return this.splitWithOneItemRepeatingFragment(chain, start, i);
            }
            previous = current;
        }
        if (start >= 0) {
            return this.splitWithOneItemRepeatingFragment(chain, start, chain.size());
        }
        return false;
    }

    private boolean splitWithOneItemRepeatingFragment(@NotNull Chain<T> chain, int start, int i) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/jetbrains/nodejs/run/profile/cpu/calculation/ChainProcessor", "splitWithOneItemRepeatingFragment"));
        }
        List<Chain<T>> chains = chain.splitWithRollup(start, i, 1);
        for (Chain<T> subChain : chains) {
            if (subChain.isRolled()) {
                this.myRollUp.add(subChain);
                continue;
            }
            this.myInput.add(subChain);
        }
        return true;
    }
}

