/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.BinaryOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webcore.util.CommandLineUtil;
import com.jetbrains.nodejs.run.profile.cpu.calculation.PlotParameters;
import com.jetbrains.nodejs.run.profile.cpu.calculation.PlotSizeParameters;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8LogTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GnuPlotRunner {
    static final String PNGCAIRO = "pngcairo";
    private static final String PNG = "png";
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.calculation.GnuPlotRunner");
    private final List<String> myLines;
    private final File myExePath;
    private File myTimeline;
    private String myErrorText;
    private MyOutputReader myListener;
    private ExecutorService myService;
    private byte[] myImage;
    private final PlotParameters myParameters;
    private boolean myImageCreatedOk;
    private boolean myNoCairo;

    public GnuPlotRunner(String gnuPlotExecutablePath, List<String> lines, @Nullable PlotSizeParameters forcedSize) {
        this.myExePath = new File(gnuPlotExecutablePath);
        this.myLines = lines;
        this.myParameters = new PlotParameters(this.myLines, forcedSize);
    }

    public boolean isNoCairo() {
        return this.myNoCairo;
    }

    public void setNoCairo(boolean noCairo) {
        this.myNoCairo = noCairo;
    }

    public boolean process(@Nullable ProgressIndicator indicator) {
        if (!this.myExePath.exists()) {
            return false;
        }
        if (this.myLines.isEmpty()) {
            this.myErrorText = "Empty input script";
            return false;
        }
        if (this.myNoCairo) {
            this.fixTerminal(indicator);
        }
        this.prepareScript();
        boolean wasOk = this.processScript(indicator);
        if (!wasOk && !this.myNoCairo && this.tryFixTerminal(indicator)) {
            this.myListener = null;
            wasOk = this.processScript(indicator);
            if (!wasOk && this.wasWrongTerminal()) {
                return this.createError("Gnuplot seems to have no pngcairo or png terminals.\nPlease install one of these terminals.\n");
            }
            return wasOk;
        }
        if (!wasOk && this.isNoDataCase()) {
            return this.createError("No valid data points in selected area\n\n");
        }
        return wasOk;
    }

    private boolean isNoDataCase() {
        if (this.myListener == null) {
            return false;
        }
        String error = this.myListener.getError();
        return error.contains("Skipping data file with no valid points") || error.contains("Can't plot with an empty ");
    }

    private boolean wasWrongTerminal() {
        if (this.myListener == null) {
            return false;
        }
        String error = this.myListener.getError();
        return error.contains("unknown or ambiguous terminal type");
    }

    private boolean tryFixTerminal(ProgressIndicator indicator) {
        return this.wasWrongTerminal() && this.fixTerminal(indicator);
    }

    private boolean fixTerminal(ProgressIndicator indicator) {
        for (int i = 0; i < this.myLines.size(); ++i) {
            String line = this.myLines.get(i);
            if (!line.contains("set terminal pngcairo")) continue;
            this.myLines.set(i, line.replace("set terminal pngcairo", "set terminal png"));
            if (indicator != null) {
                indicator.setText("Gnuplot: setting terminal to png");
            }
            this.myNoCairo = true;
            this.myImage = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean processScript(@Nullable ProgressIndicator indicator) {
        block14: {
            try {
                this.writeToFile();
            }
            catch (IOException e) {
                return this.createError("Can not create temp files for gnuplot processing: " + e.getMessage());
            }
            GeneralCommandLine commandLine = this.createCommandLine();
            LOG.info("Going to create gnuplot: '" + commandLine.getCommandLineString() + "'");
            MyOSProcessHandler processHandler = null;
            this.initExecutionPool();
            processHandler = new MyOSProcessHandler(commandLine);
            this.myListener = new MyOutputReader();
            processHandler.addProcessListener((ProcessListener)this.myListener);
            processHandler.startNotify();
            V8LogTransformer.waitForProcessUnderProgress((OSProcessHandler)processHandler, indicator);
            if (processHandler == null) break block14;
            try {
                GnuPlotRunner.closeStreams((BaseOSProcessHandler)processHandler);
            }
            catch (IOException e) {
                LOG.info(e.getMessage(), (Throwable)e);
            }
            this.myImage = processHandler.getOutput();
            processHandler.destroyProcess();
            break block14;
            catch (ExecutionException e) {
                boolean bl;
                block15: {
                    try {
                        LOG.info(e.getMessage(), (Throwable)e);
                        bl = this.createError("Can not start gnuplot process: " + e.getMessage());
                        if (processHandler == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (processHandler != null) {
                            try {
                                GnuPlotRunner.closeStreams(processHandler);
                            }
                            catch (IOException e2) {
                                LOG.info(e2.getMessage(), (Throwable)e2);
                            }
                            this.myImage = processHandler.getOutput();
                            processHandler.destroyProcess();
                        }
                        throw throwable;
                    }
                    try {
                        GnuPlotRunner.closeStreams((BaseOSProcessHandler)processHandler);
                    }
                    catch (IOException e3) {
                        LOG.info(e3.getMessage(), (Throwable)e3);
                    }
                    this.myImage = processHandler.getOutput();
                    processHandler.destroyProcess();
                }
                return bl;
            }
        }
        boolean bl = this.myImageCreatedOk = this.myImage.length > 0 && this.myErrorText == null;
        if (this.myImageCreatedOk) {
            this.myTimeline.deleteOnExit();
        }
        return this.myImageCreatedOk;
    }

    public boolean isImageCreatedOk() {
        return this.myImageCreatedOk;
    }

    public byte[] getImage() {
        return this.myImage;
    }

    private static void closeStreams(BaseOSProcessHandler processHandler) throws IOException {
        Process process = processHandler.getProcess();
        process.getOutputStream().close();
        process.getInputStream().close();
        process.getErrorStream().close();
    }

    private void initExecutionPool() {
        if (this.myService != null) {
            return;
        }
        this.myService = Executors.newFixedThreadPool(3, new ThreadFactory(){
            int cnt = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "gnuplot runner #" + this.cnt++);
            }
        });
    }

    private void writeToFile() throws IOException {
        this.myTimeline = FileUtil.createTempFile((String)"v8timeline", (String)".plt", (boolean)false);
        FileUtil.writeToFile((File)this.myTimeline, (String)StringUtil.join(this.myLines, (String)"\n"));
    }

    private boolean createError(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/run/profile/cpu/calculation/GnuPlotRunner", "createError"));
        }
        this.myErrorText = text;
        return false;
    }

    public String getErrorText() {
        boolean imageCreationProblem = this.myListener != null && (this.myImage == null || this.myImage.length == 0);
        String listenerError = imageCreationProblem ? this.myListener.getError() : null;
        return V8LogTransformer.combineErrors(this.myErrorText, null, listenerError, "Problem with timeline chart creation: ");
    }

    private void prepareScript() {
        if (!this.myLines.get(this.myLines.size() - 1).contains("quit")) {
            this.myLines.add("quit");
        }
        this.myLines.add("\n");
    }

    public PlotParameters getParameters() {
        return this.myParameters;
    }

    public static void escapeLines(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            lines.set(i, GnuPlotRunner.escapeLine(line));
        }
    }

    private static String escapeLine(String line) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '%') {
                sb.append('%');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private GeneralCommandLine createCommandLine() {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        CommandLineUtil.configureShellEnvironment((GeneralCommandLine)commandLine, (boolean)true, Collections.emptyMap());
        commandLine.withWorkDirectory(this.myExePath.getParentFile());
        commandLine.setExePath(FileUtil.toSystemDependentName((String)this.myExePath.getAbsolutePath()));
        commandLine.addParameters(new String[]{this.myTimeline.getAbsolutePath()});
        return commandLine;
    }

    public static void main(String[] args) throws IOException {
        String text = FileUtil.loadFile((File)new File("D:\\testProjects\\ws1\\a.plt"));
        String[] lines = text.split("\n");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(lines));
        GnuPlotRunner.escapeLines(list);
        GnuPlotRunner runner = new GnuPlotRunner("D:/Program Files/gnuplot/bin/gnuplot.exe", list, null);
        if (!runner.process(null)) {
            System.err.println(runner.myErrorText);
        }
        File out = FileUtil.createTempFile((File)new File("D:\\testProjects\\ws1"), (String)"out", (String)".png", (boolean)true, (boolean)false);
        FileUtil.writeToFile((File)out, (byte[])runner.getImage());
    }

    private class MyOSProcessHandler
    extends BinaryOSProcessHandler {
        private MyOSProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/run/profile/cpu/calculation/GnuPlotRunner$MyOSProcessHandler", "<init>"));
            }
            super(commandLine);
        }

        public void destroyProcess() {
            GnuPlotRunner.this.myService.shutdownNow();
            GnuPlotRunner.this.myService = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            super.destroyProcess();
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/jetbrains/nodejs/run/profile/cpu/calculation/GnuPlotRunner$MyOSProcessHandler", "executeOnPooledThread"));
            }
            Future<?> future = GnuPlotRunner.this.myService.submit(task);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/calculation/GnuPlotRunner$MyOSProcessHandler", "executeOnPooledThread"));
            }
            return future;
        }
    }

    private static class MyOutputReader
    extends ProcessAdapter {
        private final StringBuilder myErr;
        private final List<String> myOut = new ArrayList<String>();

        private MyOutputReader() {
            this.myErr = new StringBuilder();
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            String text = event.getText().trim();
            if (outputType == ProcessOutputTypes.STDERR) {
                if (this.myErr.length() > 0) {
                    this.myErr.append("\n");
                }
                this.myErr.append(text);
            } else if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOut.add(text);
            }
        }

        public String getError() {
            return this.myErr.toString();
        }

        public boolean haveError() {
            return this.myErr.length() > 0;
        }

        public List<String> getOutput() {
            return this.myOut;
        }
    }
}

