/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.jetbrains.nodejs.run.profile.cpu.calculation.GnuPlotRunner;
import com.jetbrains.nodejs.run.profile.cpu.calculation.PlotParameters;
import com.jetbrains.nodejs.run.profile.cpu.calculation.PlotSizeParameters;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8LogTransformer;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogProcessor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final File myLogFile;
    @NotNull
    private final String myNodePath;
    @NotNull
    private final String myTickPath;
    @Nullable
    private final String myGnuplotExePath;
    private boolean myTimelineCalled;
    private boolean myCallTreesOk;
    private boolean myTimelineOk;
    private final Map<Pair<Integer, Integer>, GnuPlotRunner> myTimelineVariants;
    private boolean myChartCreated;
    private V8LogTransformer myCallTreesTransformer;
    private V8LogTransformer myTimelineTransformer;
    private int myZoomStartX;
    private int myZoomEndX;

    public LogProcessor(@NotNull Project project, @NotNull File logFile, @NotNull String nodePath, @NotNull String tickPath, @Nullable String gnuplotExePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "<init>"));
        }
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "<init>"));
        }
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "<init>"));
        }
        if (tickPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tickPath", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "<init>"));
        }
        this.myZoomStartX = -1;
        this.myZoomEndX = -1;
        this.myProject = project;
        this.myLogFile = logFile;
        this.myNodePath = nodePath;
        this.myTickPath = tickPath;
        this.myGnuplotExePath = gnuplotExePath;
        this.myTimelineVariants = new HashMap<Pair<Integer, Integer>, GnuPlotRunner>();
    }

    public void setZoomStartX(int zoomStartX) {
        this.myZoomStartX = zoomStartX;
    }

    public void setZoomEndX(int zoomEndX) {
        this.myZoomEndX = zoomEndX;
    }

    public boolean isTimelineCalled() {
        return this.myTimelineCalled;
    }

    public boolean isCallTreesOk() {
        return this.myCallTreesOk;
    }

    public boolean isTimelineOk() {
        return this.myTimelineOk;
    }

    public Map<Pair<Integer, Integer>, GnuPlotRunner> getTimelineVariants() {
        return this.myTimelineVariants;
    }

    public boolean isChartCreated() {
        return this.myChartCreated;
    }

    public V8LogTransformer getCallTreesTransformer() {
        return this.myCallTreesTransformer;
    }

    public V8LogTransformer getTimelineTransformer() {
        return this.myTimelineTransformer;
    }

    public void processInBackground(final @NotNull Runnable continuation, final boolean createChart) {
        if (continuation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continuation", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "processInBackground"));
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Processing V8 log file", true, this.getOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor$1", "run"));
                }
                LogProcessor.this.process(indicator, createChart);
            }

            public void onSuccess() {
                continuation.run();
            }
        });
    }

    private PerformInBackgroundOption getOption() {
        return new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void processSentToBackground() {
            }
        };
    }

    private void process(@NotNull ProgressIndicator indicator, boolean createChart) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "process"));
        }
        indicator.setText("Calling log file processing to create call trees...");
        this.myCallTreesTransformer = V8LogTransformer.createCallTreesTransformer(this.myLogFile, this.myNodePath, this.myTickPath);
        this.setZoom(this.myCallTreesTransformer);
        this.myCallTreesOk = this.myCallTreesTransformer.process(indicator);
        indicator.setText("Call trees " + (this.myCallTreesOk ? "created successfully." : "creation failed."));
        indicator.checkCanceled();
        if (!createChart) {
            return;
        }
        if (this.myCallTreesOk && !StringUtil.isEmptyOrSpaces((String)this.myGnuplotExePath)) {
            this.myTimelineCalled = true;
            indicator.setText("Calling log file processing to create timeline chart...");
            this.myTimelineTransformer = V8LogTransformer.createTimelineTransformer(this.myLogFile, this.myNodePath, this.myTickPath);
            this.setZoom(this.myTimelineTransformer);
            this.myTimelineOk = this.myTimelineTransformer.process(indicator);
            indicator.setText("Timeline chart gnuplot script " + (this.myTimelineOk ? "created successfully." : "creation failed."));
            indicator.checkCanceled();
            if (this.myTimelineOk) {
                TimelineCreator creator = new TimelineCreator(indicator, null, new PlotSizeParameters(800, 350, 8, 14, 18, 99, 0, 8, 7), new PlotSizeParameters(1200, 500, 9, 10, 15, 99, 0, 9, 8));
                creator.create();
                if (this.myChartCreated && creator.isNoCairo()) {
                    NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("Timeline was created in png format.\nFor better view, install gnuplot pngcairo terminal.", MessageType.WARNING).notify(this.myProject);
                }
            }
        }
    }

    public void exportImage(@NotNull File imgFile, @Nullable byte[] image) throws IOException {
        if (imgFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imgFile", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "exportImage"));
        }
        if (this.myChartCreated && image != null) {
            FileUtil.writeToFile((File)imgFile, (byte[])image);
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile(imgFile);
        }
    }

    public void exportData(@NotNull File textFile) throws IOException {
        if (textFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFile", "com/jetbrains/nodejs/run/profile/cpu/calculation/LogProcessor", "exportData"));
        }
        if (this.myCallTreesOk) {
            FileUtil.writeToFile((File)textFile, (String)StringUtil.join(this.myCallTreesTransformer.getResult(), (String)"\n"));
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile(textFile);
        }
    }

    private void setZoom(V8LogTransformer transformer) {
        if (this.myZoomStartX != -1 && this.myZoomEndX != -1) {
            transformer.setZoomStartX(this.myZoomStartX);
            transformer.setZoomEndX(this.myZoomEndX);
        }
    }

    public LogProcessor cloneMe() {
        LogProcessor processor = new LogProcessor(this.myProject, this.myLogFile, this.myNodePath, this.myTickPath, this.myGnuplotExePath);
        processor.setZoomStartX(this.myZoomStartX);
        processor.setZoomEndX(this.myZoomEndX);
        return processor;
    }

    public String getFileName() {
        return this.myLogFile.getName();
    }

    private class TimelineCreator {
        private final ProgressIndicator myIndicator;
        private final PlotSizeParameters[] myParametersList;
        private boolean myNoCairo;

        public TimelineCreator(ProgressIndicator indicator, PlotSizeParameters ... parametersList) {
            this.myIndicator = indicator;
            this.myParametersList = parametersList;
        }

        public void create() {
            this.myNoCairo = false;
            List<String> lines = LogProcessor.this.myTimelineTransformer.getResult();
            GnuPlotRunner.escapeLines(lines);
            for (PlotSizeParameters parameters : this.myParametersList) {
                Pair<Integer, Integer> size = parameters == null ? PlotParameters.ourDefault.getImageSize() : parameters.getImageSize();
                String sizeStr = size.getFirst() + " x " + size.getSecond();
                this.myIndicator.setText("Calling gnuplot to create timeline chart image " + sizeStr + "...");
                GnuPlotRunner runner = new GnuPlotRunner(LogProcessor.this.myGnuplotExePath, lines, parameters);
                runner.setNoCairo(this.myNoCairo);
                boolean created = runner.process(this.myIndicator);
                if (!this.myNoCairo) {
                    this.myNoCairo = runner.isNoCairo();
                }
                LogProcessor.this.myChartCreated = LogProcessor.this.myChartCreated | created;
                LogProcessor.this.myTimelineVariants.put(runner.getParameters().getSize(), runner);
                this.myIndicator.setText("Timeline chart image " + sizeStr + (created ? " created successfully." : " creation failed."));
                this.myIndicator.checkCanceled();
                if (!created) break;
            }
        }

        public boolean isNoCairo() {
            return this.myNoCairo;
        }
    }
}

