/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8TickProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.ArgumentType;
import java.io.IOException;
import java.util.List;

abstract class ParserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.v8log.ParserBase");
    public static final ParserBase EMPTY = new ParserBase(0, -1, new ArgumentType[0]){

        @Override
        protected void process(List<String> strings) throws IOException {
        }
    };
    private final int myMinNumArgs;
    private final int myMaxNumArgs;
    private final ArgumentType[] myTypes;

    public ParserBase(int minNumArgs, int maxNumArgs, ArgumentType ... types) {
        this.myMinNumArgs = minNumArgs;
        this.myMaxNumArgs = maxNumArgs;
        this.myTypes = types;
    }

    public void consume(List<String> strings) throws IOException {
        if (this.myMinNumArgs > strings.size() || this.myMaxNumArgs > 0 && this.myMaxNumArgs < strings.size()) {
            LOG.info("wrong number of arguments for " + this.getClass().getName());
            return;
        }
        for (int i = 0; i < strings.size(); ++i) {
            String s = strings.get(i);
            if (this.myTypes.length <= i) break;
            if (ArgumentType.address.equals((Object)this.myTypes[i]) && V8TickProcessor.parseAddress(s) == null) {
                LOG.info("string in position " + i + " is not an address: " + s + " for " + this.getClass().getName());
                return;
            }
            if (!ArgumentType.number.equals((Object)this.myTypes[i]) || V8TickProcessor.parseNumber(s) != -1L) continue;
            LOG.info("string in position " + i + " is not a number: " + s + " for " + this.getClass().getName());
            return;
        }
        this.process(strings);
    }

    protected abstract void process(List<String> var1) throws IOException;
}

