/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.util.Processor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TickIndexer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.EventsStripeData;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TimerEventsReader {
    private final CompositeCloseable myResources;
    private final LinksReaderFactory<V8LogIndexesWriter.TimerEvent> myEventsReader;
    @NotNull
    private final TickIndexer myEventsTickIndexer;
    @NotNull
    private final TickIndexer myEventsEndTickIndexer;
    private final Object myLock;

    public TimerEventsReader(CompositeCloseable resources, LinksReaderFactory<V8LogIndexesWriter.TimerEvent> eventsReader, @NotNull TickIndexer eventsTickIndexer, @NotNull TickIndexer eventsEndTickIndexer) {
        if (eventsTickIndexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventsTickIndexer", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/TimerEventsReader", "<init>"));
        }
        if (eventsEndTickIndexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventsEndTickIndexer", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/TimerEventsReader", "<init>"));
        }
        this.myLock = new Object();
        this.myResources = resources;
        this.myEventsReader = eventsReader;
        this.myEventsTickIndexer = eventsTickIndexer;
        this.myEventsEndTickIndexer = eventsEndTickIndexer;
    }

    @NotNull
    public TickIndexer getEventsTickIndexer() {
        TickIndexer tickIndexer = this.myEventsTickIndexer;
        if (tickIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/TimerEventsReader", "getEventsTickIndexer"));
        }
        return tickIndexer;
    }

    @NotNull
    public TickIndexer getEventsEndTickIndexer() {
        TickIndexer tickIndexer = this.myEventsEndTickIndexer;
        if (tickIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/TimerEventsReader", "getEventsEndTickIndexer"));
        }
        return tickIndexer;
    }

    public LinksReaderFactory<V8LogIndexesWriter.TimerEvent> getEventsReader() {
        return this.myEventsReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventsStripeData getTimerEvents(long from, long to) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myEventsTickIndexer.getNumTicks() == 0) {
                return new EventsStripeData();
            }
            from = from < 0L ? 0L : from;
            to = to < 0L || to > this.myEventsEndTickIndexer.getLastTick() ? this.myEventsEndTickIndexer.getLastTick() : to;
            EventsReader reader = new EventsReader(from, to);
            reader.execute();
            List<V8LogIndexesWriter.TimerEvent> events = reader.getEvents();
            EventsStripeData eventsStripeData = new EventsStripeData();
            for (V8LogIndexesWriter.TimerEvent event : events) {
                eventsStripeData.addEvent(event);
            }
            return eventsStripeData;
        }
    }

    private class EventsReader {
        private final long myFromTs;
        private final long myToTs;
        private int myFromRecord;
        private int myToRecord;
        private List<Long> myTimes;
        private List<V8LogIndexesWriter.TimerEvent> myEvents;

        public EventsReader(long fromTs, long toTs) {
            this.myFromTs = fromTs;
            this.myToTs = toTs;
            this.myFromRecord = Math.min(TimerEventsReader.this.myEventsTickIndexer.getFloorIndexFor(fromTs), TimerEventsReader.this.myEventsEndTickIndexer.getFloorIndexFor(fromTs));
            this.myToRecord = TimerEventsReader.this.myEventsTickIndexer.getCeilIndexFor(toTs);
        }

        public void execute() throws IOException {
            this.myEvents = new ArrayList<V8LogIndexesWriter.TimerEvent>();
            LinksReader reader = TimerEventsReader.this.myEventsReader.create(true);
            if (this.myFromRecord != 0) {
                reader.skip(this.myFromRecord, true);
            }
            reader.iterateRandomLen(new Processor<V8LogIndexesWriter.TimerEvent>(){
                int cnt;
                {
                    this.cnt = EventsReader.this.myFromRecord;
                }

                public boolean process(V8LogIndexesWriter.TimerEvent event) {
                    long start = event.getStartNanos();
                    long end = start + event.getPause();
                    if ((start >= EventsReader.this.myFromTs || end >= EventsReader.this.myFromTs) && (start <= EventsReader.this.myToTs || end <= EventsReader.this.myToTs) || start <= EventsReader.this.myFromTs && end >= EventsReader.this.myToTs) {
                        EventsReader.this.myEvents.add(event);
                    }
                    ++this.cnt;
                    return this.cnt <= EventsReader.this.myToRecord || start <= EventsReader.this.myToTs;
                }
            });
        }

        public List<V8LogIndexesWriter.TimerEvent> getEvents() {
            return this.myEvents;
        }
    }
}

