/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.nodejs.run.profile.cpu.v8log.V8CpuIndexManager;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8TickProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class V8CachingLogProcessor {
    @NotNull
    private final Project myProject;
    private final CompositeCloseable myResources;
    @NotNull
    private final File myV8log;
    private final long myNano;
    private final V8CpuIndexManager myManager;
    private final ByteArrayWrapper myDigest;

    public V8CachingLogProcessor(@NotNull Project project, CompositeCloseable resources, @NotNull File v8log, long distortionPerEntryNano) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8CachingLogProcessor", "<init>"));
        }
        if (v8log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v8log", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8CachingLogProcessor", "<init>"));
        }
        this.myProject = project;
        this.myResources = resources;
        this.myV8log = v8log;
        this.myNano = distortionPerEntryNano;
        this.myManager = new V8CpuIndexManager(v8log);
        this.myDigest = new ByteArrayWrapper(this.myManager.createDigest(v8log));
    }

    public boolean willTakeFromCache() {
        return this.myManager.isInitialized();
    }

    public V8LogCachingReader getFromCacheOrProcess(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8CachingLogProcessor", "getFromCacheOrProcess"));
        }
        if (this.myManager.isInitialized()) {
            try {
                indicator.setText("Reading indexes...");
                V8LogCachingReader reader = this.myManager.initReader(this.myDigest, this.myV8log, this.myResources);
                if (reader != null) {
                    return reader;
                }
            }
            catch (IOException e) {
                this.myManager.clearRoot();
            }
        }
        V8TickProcessor processor = new V8TickProcessor(this.myDigest, this.myV8log, this.myNano, this.myManager.getIndexFiles());
        V8LogCachingReader reader = processor.execute(this.myResources);
        indicator.setText("Recording indexes...");
        this.myManager.recordReader(reader);
        return reader;
    }
}

