/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.idea.RareLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.ParserBase;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LineReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class V8LogReader {
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.v8log.V8LogReader"), (boolean)false);
    private final File myFile;
    private final Map<String, ParserBase> myParsers;

    public V8LogReader(File file, Map<String, ParserBase> parsers) {
        this.myFile = file;
        this.myParsers = parsers;
    }

    public void read() throws IOException {
        try (FileInputStream fis = new FileInputStream(this.myFile);){
            new V8LineReader(new BufferedInputStream(fis)).readLines((ThrowableConsumer<String, IOException>)((ThrowableConsumer)line -> this.processLine((String)line)), CharsetToolkit.UTF8_CHARSET);
        }
    }

    private void processLine(String line) throws IOException {
        String[] fields = line.split(",");
        if (fields.length == 0 || StringUtil.isEmptyOrSpaces((String)fields[0])) {
            return;
        }
        ParserBase parser = this.myParsers.get(fields[0].trim());
        if (parser == null) {
            LOG.info("Unknown v8 log field: " + fields[0]);
        } else {
            parser.consume(Arrays.asList(fields).subList(1, fields.length));
        }
    }
}

