/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TimeDistribution;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.io.LinksWriter;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import gnu.trove.TLongIntHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class V8LogStackDurationWorker
implements Closeable {
    private TLongIntHashMap myDurationByIdMap;
    @NotNull
    private final IndexFiles<V8LogIndexesWriter.Category> myIndexFiles;
    private ArrayList<Duration> myStack;
    private final LinksWriter<Long> myWriter;
    private long myDurationCnt;
    private long myTick;
    private File myNumDurationFile;
    private File myDurationFile;
    private final File myNumDurationIdFile;
    private final File myDurationIdFile;
    private final Map<Long, TimeDistribution> myDistribution;
    private final Map<Long, TimeDistribution> mySelfDistribution;
    private File myDistributionFile;
    private File mySelfDistributionFile;

    public V8LogStackDurationWorker(@NotNull IndexFiles<V8LogIndexesWriter.Category> indexFiles) throws IOException {
        if (indexFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexFiles", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogStackDurationWorker", "<init>"));
        }
        this.myIndexFiles = indexFiles;
        this.myNumDurationIdFile = indexFiles.generate(V8LogIndexesWriter.Category.numDurationByTick1, "numDuration");
        this.myDurationIdFile = indexFiles.generate(V8LogIndexesWriter.Category.durationByTick1, "duration");
        this.myWriter = new LinksWriter<Long>(this.myNumDurationIdFile, this.myDurationIdFile, new LongRawSerializer());
        this.myStack = new ArrayList();
        this.myDurationByIdMap = new TLongIntHashMap();
        this.myDurationCnt = 0L;
        this.myTick = 0L;
        this.myDistribution = new HashMap<Long, TimeDistribution>();
        this.mySelfDistribution = new HashMap<Long, TimeDistribution>();
    }

    public LinksReaderFactory<Long> getDurationFactory() {
        return new LinksReaderFactory<Long>(new LongRawSerializer(), this.myNumDurationFile, this.myDurationFile);
    }

    public void tick(long nanos, List<Long> bottomUpStringNumbers) throws IOException {
        Duration oldId;
        Long newId;
        int newIdx;
        this.myTick = nanos;
        int stackId = this.myStack.size() - 1;
        for (newIdx = bottomUpStringNumbers.size() - 1; newIdx >= 0 && stackId >= 0 && (newId = bottomUpStringNumbers.get(newIdx)).equals((oldId = this.myStack.get(stackId)).getStringId()); --newIdx, --stackId) {
        }
        boolean selfTimePut = false;
        for (int i = 0; i <= stackId; ++i) {
            Duration duration = this.myStack.get(i);
            int interval = (int)(nanos - duration.getStartTs());
            this.myDurationByIdMap.put(duration.getDurationId(), interval);
            if (!selfTimePut && 1L != duration.getStringId()) {
                V8LogStackDurationWorker.registerInDistribution(this.mySelfDistribution, duration.getStringId(), duration.getStartTs(), interval);
                selfTimePut = true;
            }
            V8LogStackDurationWorker.registerInDistribution(this.myDistribution, duration.getStringId(), duration.getStartTs(), interval);
        }
        List<Duration> tail = this.myStack.subList(stackId + 1, this.myStack.size());
        this.myStack = new ArrayList(bottomUpStringNumbers.size());
        ArrayList<Long> durationIdsList = new ArrayList<Long>();
        for (int i = 0; i <= newIdx; ++i) {
            long durationId;
            ++this.myDurationCnt;
            this.myStack.add(new Duration(bottomUpStringNumbers.get(i), durationId, nanos));
            durationIdsList.add(durationId);
        }
        for (Duration duration : tail) {
            this.myStack.add(duration);
            durationIdsList.add(duration.getDurationId());
        }
        this.myWriter.write(durationIdsList);
    }

    /*
     * WARNING - void declaration
     */
    private static void registerInDistribution(@NotNull Map<Long, TimeDistribution> map, long stringId, long startTs, int n) {
        void interval;
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogStackDurationWorker", "registerInDistribution"));
        }
        TimeDistribution distribution = map.get(stringId);
        if (distribution == null) {
            distribution = new TimeDistribution();
            map.put(stringId, distribution);
        }
        distribution.register(startTs, (long)interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateDurationsWriteDistribution(@NotNull Long maxStringId) throws IOException {
        if (maxStringId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxStringId", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogStackDurationWorker", "recalculateDurationsWriteDistribution"));
        }
        this.myWriter.close();
        for (Duration duration : this.myStack) {
            this.myDurationByIdMap.put(duration.getDurationId(), (int)(this.myTick - duration.getStartTs()));
        }
        try (CompositeCloseable closeable = new CompositeCloseable();){
            this.myNumDurationFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.numDurationByTick2, "numDuration2");
            this.myDurationFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.durationByTick2, "duration2");
            LinksWriter<Long> writer = closeable.register(new LinksWriter<Long>(this.myNumDurationFile, this.myDurationFile, new LongRawSerializer()));
            LinksReader<Long> reader = closeable.register(new LinksReaderFactory<Long>(new LongRawSerializer(), this.myNumDurationIdFile, this.myDurationIdFile).create(true));
            reader.iterateWithThrowable((ThrowableConsumer<List<Long>, IOException>)((ThrowableConsumer)longs -> {
                ArrayList<Long> duration = new ArrayList<Long>();
                for (Long id : longs) {
                    duration.add(Long.valueOf(this.myDurationByIdMap.get(id.longValue())));
                }
                writer.write(duration);
            }));
        }
        this.myDurationByIdMap = null;
        this.writeDistributions(maxStringId);
    }

    private void writeDistributions(Long maxStringId) throws IOException {
        this.myDistributionFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.distribution, "Distribution");
        this.mySelfDistributionFile = this.myIndexFiles.generate(V8LogIndexesWriter.Category.selfDistribution, "SelfDistribution");
        try (CompositeCloseable closeable = new CompositeCloseable();){
            V8LogStackDurationWorker.writeDistributionMap(this.myDistribution, this.myDistributionFile, maxStringId, closeable);
            V8LogStackDurationWorker.writeDistributionMap(this.mySelfDistribution, this.mySelfDistributionFile, maxStringId, closeable);
        }
    }

    private static void writeDistributionMap(@NotNull Map<Long, TimeDistribution> map, @NotNull File distributionFile, Long maxStringId, CompositeCloseable closeable) throws IOException {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogStackDurationWorker", "writeDistributionMap"));
        }
        if (distributionFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "distributionFile", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogStackDurationWorker", "writeDistributionMap"));
        }
        RawSerializer<TimeDistribution> serializer = TimeDistribution.getSerializer(TimeDistribution.STANDARD);
        SequentialRawWriter<TimeDistribution> writer = closeable.register(new SequentialRawWriter<TimeDistribution>(distributionFile, serializer));
        for (long i = 0L; i < maxStringId; ++i) {
            TimeDistribution distribution = map.get(i);
            distribution = distribution == null ? new TimeDistribution() : distribution;
            writer.write(distribution);
        }
    }

    @Override
    public void close() throws IOException {
        this.myWriter.close();
    }

    public File getDistributionFile() {
        return this.myDistributionFile;
    }

    public File getSelfDistributionFile() {
        return this.mySelfDistributionFile;
    }

    private static class Duration {
        private final long myStringId;
        private final long myDurationId;
        private final long myStartTs;

        public Duration(long stringId, long durationId, long startTs) {
            this.myStringId = stringId;
            this.myDurationId = durationId;
            this.myStartTs = startTs;
        }

        public long getStringId() {
            return this.myStringId;
        }

        public long getDurationId() {
            return this.myDurationId;
        }

        public long getStartTs() {
            return this.myStartTs;
        }
    }
}

