/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.CpuDiffCalculator;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.ShowSnapshotDiffDialog;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;

public class V8CpuDiffAction
extends DumbAwareAction {
    private final Project myProject;
    private final V8LogCachingReader myReader;

    public V8CpuDiffAction(Project project, V8LogCachingReader reader) {
        super("Compare with...", "Compare with another V8 log", AllIcons.Actions.Diff);
        this.myProject = project;
        this.myReader = reader;
    }

    public void actionPerformed(AnActionEvent e) {
        ShowSnapshotDiffDialog dialog = new ShowSnapshotDiffDialog(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"log"), this.myProject, "Log was recorded: ");
        VirtualFile[] files = dialog.choose(this.myProject, new VirtualFile[0]);
        if (files.length != 1) {
            return;
        }
        VirtualFile file = files[0];
        if (file != null) {
            File changedFile = new File(file.getPath());
            if (FileUtil.filesEqual((File)changedFile, (File)this.myReader.getV8LogFile())) {
                NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Can not show diff with itself.", MessageType.WARNING).notify(this.myProject);
                return;
            }
            CpuDiffCalculator calculateSecondAndDiff = new CpuDiffCalculator(this.myProject, this.myReader, changedFile, !dialog.isAfter());
            ProgressManager.getInstance().run((Task)calculateSecondAndDiff);
        }
    }
}

