/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.CallHolder;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNode;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNodeTreeCellRenderer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.V8CpuDiffTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.V8DiffFlatViewTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8CpuDiffFlatViewComponent
implements ProfilingView<V8ProfilingCallTreeTable> {
    @NotNull
    private final Project myProject;
    private final Disposable myDisposable;
    @NotNull
    private final V8LogCachingReader myBaseReader;
    @NotNull
    private final V8LogCachingReader myChangedReader;
    @NotNull
    private final List<Pair<String, List<DiffNode>>> myFlatDiff;
    private final DiffNodeTreeCellRenderer myRenderer;
    private JComponent myMainPane;
    private V8ProfilingCallTreeTable myTable;

    public V8CpuDiffFlatViewComponent(@NotNull Project project, Disposable disposable, @NotNull V8LogCachingReader baseReader, @NotNull V8LogCachingReader changedReader, @NotNull List<Pair<String, List<DiffNode>>> flatDiff) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/V8CpuDiffFlatViewComponent", "<init>"));
        }
        if (baseReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseReader", "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/V8CpuDiffFlatViewComponent", "<init>"));
        }
        if (changedReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedReader", "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/V8CpuDiffFlatViewComponent", "<init>"));
        }
        if (flatDiff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flatDiff", "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/V8CpuDiffFlatViewComponent", "<init>"));
        }
        this.myProject = project;
        this.myDisposable = disposable;
        this.myBaseReader = baseReader;
        this.myChangedReader = changedReader;
        this.myFlatDiff = flatDiff;
        this.myRenderer = new DiffNodeTreeCellRenderer();
        this.myRenderer.setBaseTicks((int)this.myBaseReader.getNumTicks());
        this.myRenderer.setChangedTicks((int)this.myChangedReader.getNumTicks());
        this.createMainComponent();
    }

    private void createMainComponent() {
        List<ColumnInfo> columns = V8CpuDiffTableModel.createTopDownColumns((TreeCellRenderer)((Object)this.myRenderer), (int)this.myBaseReader.getNumTicks(), (int)this.myChangedReader.getNumTicks());
        V8DiffFlatViewTableModel mainModel = new V8DiffFlatViewTableModel(columns.toArray(new ColumnInfo[columns.size()]), (int)this.myBaseReader.getNumTicks(), (int)this.myChangedReader.getNumTicks());
        for (Pair<String, List<DiffNode>> pair : this.myFlatDiff) {
            ChainTreeTableModel.Node keyNode = mainModel.createNode(pair.getFirst());
            mainModel.addTopKey(keyNode);
            for (DiffNode node : (List)pair.getSecond()) {
                ChainTreeTableModel.Node modelNode = mainModel.createNode(node);
                keyNode.getChildren().add(modelNode);
            }
        }
        this.myTable = new V8ProfilingCallTreeTable(this.myProject, mainModel, this.myDisposable){

            @Override
            public CallHolder getV8ProfileLine(int row) {
                Object inner;
                Object o;
                TreePath pathForRow = this.getTree().getPathForRow(row);
                if (pathForRow != null && (o = pathForRow.getLastPathComponent()) instanceof ChainTreeTableModel.Node && (inner = ((ChainTreeTableModel.Node)o).getT()) instanceof CallHolder) {
                    return (CallHolder)inner;
                }
                return null;
            }
        };
        this.myTable.setAutoResizeMode(0);
        this.myTable.getTableHeader().setResizingAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setRootVisible(false);
        this.myTable.getTree().setShowsRootHandles(true);
        this.myTable.getTree().setLineStyleAngled();
        this.defaultExpand();
        V8Utils.adjustColumnWIdths(this.myTable, null);
        new TreeTableSpeedSearch((TreeTable)this.myTable, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                Object o = path.getLastPathComponent();
                if (o instanceof V8ProfileLine) {
                    return ((V8ProfileLine)o).getFileDescriptor() != null ? ((V8ProfileLine)o).getFileDescriptor().getShortLink() : ((V8ProfileLine)o).getNotParsedCallable();
                }
                return o.toString();
            }
        });
        TreeTableWidthController controller = new TreeTableWidthController(this.myTable, this.myDisposable);
        controller.setMeaningfulRenderer((TreeCellRenderer)((Object)this.myRenderer));
        this.myTable.setController(controller);
        this.myMainPane = new JBScrollPane((Component)((Object)this.myTable));
    }

    public DiffNodeTreeCellRenderer getRenderer() {
        return this.myRenderer;
    }

    @Override
    public JComponent getMainComponent() {
        return this.myMainPane;
    }

    @Override
    public String getName() {
        return "Top Calls Diff";
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new V8Utils.LightweightEditSourceAction((JComponent)((Object)this.myTable)));
        group.add((AnAction)V8ProfilingCallTreeComponent.createFilterAction(this.myTable, "Total % Diff Filter", () -> this.defaultExpand(), () -> this.myTable.getWidthController().recalculateAll()));
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8ProfilingCallTreeTable getTreeTable() {
        return this.myTable;
    }

    @Override
    public void defaultExpand() {
        TreeTableModel mainModel = this.myTable.getTableModel();
        int count = mainModel.getChildCount(mainModel.getRoot());
        for (int i = 0; i < count; ++i) {
            this.myTable.getTree().expandPath(new TreePath(new Object[]{mainModel.getRoot(), mainModel.getChild(mainModel.getRoot(), i)}));
        }
    }
}

