/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.reading;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.lang.javascript.ui.FileColor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreeType;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.V8CpuDiffAction;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8SwitchViewActionsFactory;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartParameters;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartView;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameColors;
import com.jetbrains.nodejs.run.profile.cpu.view.CollapseNodeAction;
import com.jetbrains.nodejs.run.profile.cpu.view.CompareWithClipboard;
import com.jetbrains.nodejs.run.profile.cpu.view.CopyNameAction;
import com.jetbrains.nodejs.run.profile.cpu.view.ExpandByDefaultAction;
import com.jetbrains.nodejs.run.profile.cpu.view.ExpandNodeAction;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.view.TopCallsV8ProfilingComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.ViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8CpuViewCreatorPartner
implements ViewCreatorPartner<V8ProfilingCallTreeTable> {
    private final Project myProject;
    private final CompositeCloseable myResources;
    private final V8LogCachingReader myReader;
    @NotNull
    private final Consumer<String> myNotificator;
    private final String myDescription;
    @Nullable
    private final Long myLeftTs;
    @Nullable
    private final Long myRightTs;
    @NotNull
    private final FlameChartParameters myParameters;
    private final LineColorProvider myLineColorProvider;
    private V8ProfilingMainComponent.MyController<V8ProfilingCallTreeTable> myViewController;
    private FlameChartView myFlameChartView;
    private ActionToolbar myActionToolbar;
    private V8ProfilingCallTreeComponent myBottomUp;
    private V8ProfilingCallTreeComponent myTopDown;
    private TopCallsV8ProfilingComponent myTopCalls;

    public V8CpuViewCreatorPartner(Project project, CompositeCloseable resources, @NotNull V8LogCachingReader reader, @NotNull Consumer<String> notificator, String description, @Nullable Long leftTs, @Nullable Long rightTs, @NotNull FlameChartParameters parameters) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner", "<init>"));
        }
        if (notificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificator", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner", "<init>"));
        }
        this.myProject = project;
        this.myResources = resources;
        this.myReader = reader;
        this.myNotificator = notificator;
        this.myDescription = description;
        this.myLeftTs = leftTs;
        this.myRightTs = rightTs;
        this.myParameters = parameters;
        this.myLineColorProvider = V8CpuViewCreatorPartner.createLineColorProvider(this.myReader, this.myNotificator);
    }

    @NotNull
    public static LineColorProvider createLineColorProvider(final @NotNull V8LogCachingReader reader, final @NotNull Consumer<String> notificator) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner", "createLineColorProvider"));
        }
        if (notificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificator", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner", "createLineColorProvider"));
        }
        LineColorProvider lineColorProvider = new LineColorProvider(){

            @Override
            public Icon getFileIcon(String fileName) {
                return this.getColorByStringId(0L);
            }

            @Override
            public Icon getColorByStringId(long id) {
                if (id == -1L) {
                    return FileColor.createIcon((Color)Color.gray);
                }
                try {
                    JBColor color = FlameColors.getColor(id, reader.getCodeScopeByStringId(id));
                    return FileColor.createIcon((Color)color);
                }
                catch (IOException e) {
                    notificator.consume((Object)e.getMessage());
                    return FileColor.createIcon((Color)Color.gray);
                }
            }
        };
        if (lineColorProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner", "createLineColorProvider"));
        }
        return lineColorProvider;
    }

    @Override
    public JComponent wrapWithStandardActions(ProfilingView<V8ProfilingCallTreeTable> view, AnAction closeAction) {
        DefaultActionGroup group = new DefaultActionGroup();
        view.addActions(group);
        if (view.getTreeTable() != null) {
            DefaultActionGroup popupGroup = new DefaultActionGroup(group.getChildActionsOrStubs());
            V8ProfilingCallTreeTable table = view.getTreeTable();
            group.add((AnAction)new ExpandByDefaultAction(table, this.myViewController));
            group.add((AnAction)new V8Utils.CollapseAllAction(table));
            group.add((AnAction)new ExportStatisticsAction(this.myReader));
            group.add((AnAction)new V8CpuDiffAction(this.myProject, this.myReader));
            popupGroup.add((AnAction)new CopyNameAction(table));
            popupGroup.add(ActionManager.getInstance().getAction("$Copy"));
            popupGroup.add((AnAction)new CompareWithClipboard(table));
            popupGroup.add((AnAction)new ExpandNodeAction(table));
            popupGroup.add((AnAction)new CollapseNodeAction(table));
            PopupHandler.installPopupHandler((JComponent)((Object)view.getTreeTable()), (ActionGroup)popupGroup, (String)"V8_CPU_PROFILING_POPUP", (ActionManager)ActionManager.getInstance());
        }
        ContextHelpAction helpAction = new ContextHelpAction("reference.tool.window.v8.profiling");
        group.add((AnAction)helpAction);
        helpAction.registerCustomShortcutSet(CommonShortcuts.getContextHelp(), view.getMainComponent());
        group.add(closeAction);
        V8Utils.WithToolbarWrapper wrapper = new V8Utils.WithToolbarWrapper(view.getMainComponent(), group);
        this.myActionToolbar = wrapper.getToolbar();
        return wrapper.getMainPanel();
    }

    @Override
    public void addViews(Project project, List<ProfilingView<V8ProfilingCallTreeTable>> list, Disposable disposable) {
        try {
            V8SwitchViewActionsFactory actionsFactory = new V8SwitchViewActionsFactory(this.myViewController);
            this.myTopCalls = new TopCallsV8ProfilingComponent(project, this.myReader, this.myReader.getFlat().createPresentation(), this.myLineColorProvider, disposable, this.myNotificator);
            this.myBottomUp = new V8ProfilingCallTreeComponent(project, this.myReader, CallTreeType.bottomUp, this.myLineColorProvider, disposable, this.myNotificator);
            this.myTopDown = new V8ProfilingCallTreeComponent(project, this.myReader, CallTreeType.topDown, this.myLineColorProvider, disposable, this.myNotificator);
            this.myFlameChartView = new FlameChartView(this.myProject, this.myReader, this.myNotificator, this.myLeftTs, this.myRightTs, this.myParameters, this.myDescription, this.createViewCallback());
            this.myTopCalls.registerItself(actionsFactory);
            this.myBottomUp.registerItself(actionsFactory);
            this.myTopDown.registerItself(actionsFactory);
            actionsFactory.setFlameChartView(this.myFlameChartView);
            actionsFactory.createActions();
            list.add(this.myTopCalls);
            list.add(this.myBottomUp);
            list.add(this.myTopDown);
            list.add(this.myFlameChartView);
        }
        catch (IOException e) {
            this.myNotificator.consume((Object)e.getMessage());
        }
    }

    @NotNull
    private V8CpuViewCallback createViewCallback() {
        V8CpuViewCallback v8CpuViewCallback = new V8CpuViewCallback(){

            @Override
            public void updateActionsAvailability() {
                if (V8CpuViewCreatorPartner.this.myActionToolbar != null) {
                    V8CpuViewCreatorPartner.this.myActionToolbar.updateActionsImmediately();
                }
            }

            @Override
            public void navigateToTopCalls(@NotNull Long stackId, Point onScreen) {
                if (stackId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackId", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner$2", "navigateToTopCalls"));
                }
                if (V8CpuViewCreatorPartner.this.myTopCalls.navigateByStackTrace(stackId)) {
                    V8CpuViewCreatorPartner.this.myViewController.showTab(V8CpuViewCreatorPartner.this.myTopCalls.getName());
                } else {
                    V8CpuViewCreatorPartner.this.canNotNavigate(onScreen);
                }
            }

            @Override
            public void navigateToBottomUp(@NotNull List<Long> stackIds, Point onScreen) {
                if (stackIds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackIds", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner$2", "navigateToBottomUp"));
                }
                if (V8CpuViewCreatorPartner.this.myBottomUp.navigateByStackTrace(stackIds)) {
                    V8CpuViewCreatorPartner.this.myViewController.showTab(V8CpuViewCreatorPartner.this.myBottomUp.getName());
                } else {
                    V8CpuViewCreatorPartner.this.canNotNavigate(onScreen);
                }
            }

            @Override
            public void navigateToTopDown(@NotNull List<Long> stackIds, Point onScreen) {
                if (stackIds == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackIds", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner$2", "navigateToTopDown"));
                }
                stackIds = new ArrayList<Long>(stackIds);
                Collections.reverse(stackIds);
                if (V8CpuViewCreatorPartner.this.myTopDown.navigateByStackTrace(stackIds)) {
                    V8CpuViewCreatorPartner.this.myViewController.showTab(V8CpuViewCreatorPartner.this.myTopDown.getName());
                } else {
                    V8CpuViewCreatorPartner.this.canNotNavigate(onScreen);
                }
            }
        };
        if (v8CpuViewCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner", "createViewCallback"));
        }
        return v8CpuViewCallback;
    }

    private void canNotNavigate(Point onScreen) {
        NodeUIUtil.balloonInfo((Project)this.myProject, (String)NodeJSBundle.message("node.js.v8.cpu.navigation.not.found.error", new Object[0]), (Point)onScreen, null);
    }

    @Override
    public String errorCreated() {
        return null;
    }

    @Override
    public void announceController(V8ProfilingMainComponent.MyController<V8ProfilingCallTreeTable> controller) {
        this.myViewController = controller;
    }

    public V8ProfilingMainComponent.MyController<V8ProfilingCallTreeTable> getViewController() {
        return this.myViewController;
    }

    @Override
    public void close() {
        try {
            this.myResources.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ExportStatisticsAction
    extends AnAction {
        private final V8LogCachingReader myReader;

        public ExportStatisticsAction(V8LogCachingReader reader) {
            super("Export Profiling Statistic", "Export Profiling Statistic", AllIcons.Actions.Export);
            this.myReader = reader;
        }

        public void actionPerformed(AnActionEvent e) {
            FileSaverDescriptor descriptor = new FileSaverDescriptor("V8 CPU Profiling", "Select path to save statistics.", new String[]{"txt"});
            FileSaverDialog saverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, V8CpuViewCreatorPartner.this.myProject);
            final VirtualFileWrapper fileWrapper = saverDialog.save(V8CpuViewCreatorPartner.this.myProject.getBaseDir(), "v8_statistics.txt");
            if (fileWrapper != null) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(V8CpuViewCreatorPartner.this.myProject, "Export Profiling Statistic", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8CpuViewCreatorPartner$ExportStatisticsAction$1", "run"));
                        }
                        try {
                            UsageTrigger.trigger((String)"node.js.v8.log.profiling.export.data");
                            ExportStatisticsAction.this.myReader.createStatisticalReport(fileWrapper.getFile());
                            NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("V8 profiling statistics saved to " + fileWrapper.getFile().getName(), MessageType.INFO).notify(this.myProject);
                        }
                        catch (IOException e) {
                            NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("Problem while saving statistics file: " + e.getMessage(), MessageType.ERROR).notify(this.myProject);
                        }
                    }
                });
            }
        }
    }
}

