/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.reading;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.CpuProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartView;
import com.jetbrains.nodejs.run.profile.cpu.view.SearchInV8TreeAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import icons.NodeJSIcons;
import org.jetbrains.annotations.NotNull;

public class V8SwitchViewActionsFactory {
    private final V8ProfilingMainComponent.MyController<V8ProfilingCallTreeTable> myController;
    private CpuProfilingView myTopCalls;
    private CpuProfilingView myBottomUp;
    private CpuProfilingView myTopDown;
    private ToViewAction myToTopCalls;
    private ToViewAction myToBottomUp;
    private ToViewAction myToTopDown;
    private FlameChartView myFlameChartView;

    public V8SwitchViewActionsFactory(V8ProfilingMainComponent.MyController<V8ProfilingCallTreeTable> controller) {
        this.myController = controller;
    }

    public void createActions() {
        this.myToTopCalls = new ToViewAction("Navigate in Top Calls", this.myTopCalls, this.myController);
        this.myToBottomUp = new ToViewAction("Navigate in Bottom-up", this.myBottomUp, this.myController);
        this.myToTopDown = new ToViewAction("Navigate in Top-down", this.myTopDown, this.myController);
    }

    public void setTopCalls(CpuProfilingView topCalls) {
        this.myTopCalls = topCalls;
    }

    public void setBottomUp(CpuProfilingView bottomUp) {
        this.myBottomUp = bottomUp;
    }

    public void setTopDown(CpuProfilingView topDown) {
        this.myTopDown = topDown;
    }

    public ToViewAction getToTopCalls() {
        return this.myToTopCalls;
    }

    public ToViewAction getToBottomUp() {
        return this.myToBottomUp;
    }

    public ToViewAction getToTopDown() {
        return this.myToTopDown;
    }

    public FlameChartView getFlameChartView() {
        return this.myFlameChartView;
    }

    public void setFlameChartView(FlameChartView flameChartView) {
        this.myFlameChartView = flameChartView;
    }

    private static class ToViewAction
    extends DumbAwareAction {
        @NotNull
        private final CpuProfilingView myView;
        private final V8ProfilingMainComponent.MyController<V8ProfilingCallTreeTable> myController;

        public ToViewAction(@NotNull String name, @NotNull CpuProfilingView view, V8ProfilingMainComponent.MyController<V8ProfilingCallTreeTable> controller) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8SwitchViewActionsFactory$ToViewAction", "<init>"));
            }
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8SwitchViewActionsFactory$ToViewAction", "<init>"));
            }
            super(name, name, NodeJSIcons.Navigate_inMainTree);
            this.myView = view;
            this.myController = controller;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(V8Utils.SELECTED_CALL.getData(e.getDataContext()) != null && PlatformDataKeys.PROJECT.getData(e.getDataContext()) != null);
        }

        public void actionPerformed(AnActionEvent e) {
            V8CpuLogCall call = (V8CpuLogCall)V8Utils.SELECTED_CALL.getData(e.getDataContext());
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (call == null || project == null) {
                return;
            }
            SearchInV8TreeAction.Searcher searcher = (SearchInV8TreeAction.Searcher)this.myView.getSearcherFactory().create();
            if (!searcher.search(call.getPresentation(false), false)) {
                NodeUIUtil.balloonInfo((Project)project, (String)NodeJSBundle.message("node.js.v8.cpu.navigation.not.found.error", new Object[0]), null, null);
                return;
            }
            this.myController.showTab(this.myView.getName());
            SearchInV8TreeAction.showCallsInTree(searcher, call, this.myView.getMasterDetails());
        }
    }
}

