/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.BeforeAfter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlameChartParameters {
    private BeforeAfter<Long> mySelection;
    private Long myDetailsPosition;
    private Long myStringId;
    private boolean myNotInitial;

    public BeforeAfter<Long> getSelection() {
        return this.mySelection;
    }

    public void setSelection(BeforeAfter<Long> selection) {
        this.mySelection = selection;
    }

    public Long getDetailsPosition() {
        return this.myDetailsPosition;
    }

    public void setDetailsPosition(Long detailsPosition) {
        this.myDetailsPosition = detailsPosition;
    }

    public Long getStringId() {
        return this.myStringId;
    }

    public void setNotInitial(boolean notInitial) {
        this.myNotInitial = notInitial;
    }

    public void setStringId(Long stringId) {
        this.myStringId = stringId;
    }

    public void updateView(@NotNull FlameChartView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartParameters", "updateView"));
        }
        ArrayList<Runnable> steps = new ArrayList<Runnable>();
        if (!this.myNotInitial || this.mySelection != null) {
            steps.add(() -> {
                if (view == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartParameters", "lambda$updateView$0"));
                }
                if (this.mySelection != null) {
                    view.getOverviewChart().setSelection((Long)this.mySelection.getBefore(), (Long)this.mySelection.getAfter());
                } else {
                    view.getOverviewChart().initialSelection();
                }
            });
        }
        if (this.myDetailsPosition != null) {
            steps.add(() -> {
                if (view == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartParameters", "lambda$updateView$1"));
                }
                this.setDetails(view);
            });
        }
        if (steps.isEmpty()) {
            return;
        }
        FlameChartParameters.doStep(steps, 0);
    }

    private void setDetails(@NotNull FlameChartView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartParameters", "setDetails"));
        }
        view.getViewUpdater().afterLoad(() -> {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartParameters", "lambda$setDetails$2"));
            }
            if (view.getFlameChart().isEmpty()) {
                this.setDetails(view);
            }
            view.getFlameChart().setDetailsPosition(this.myDetailsPosition, this.myStringId == null ? -1L : this.myStringId);
        });
    }

    private static void doStep(List<Runnable> steps, int idx) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ((Runnable)steps.get(idx)).run();
            if (idx < steps.size() - 1) {
                FlameChartParameters.doStep(steps, idx + 1);
            }
        });
    }
}

