/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import java.awt.datatransfer.Transferable;

public class CompareWithClipboard
extends AnAction {
    private final V8ProfilingCallTreeTable myTable;

    public CompareWithClipboard(V8ProfilingCallTreeTable table) {
        super("Compare With Clipboard", "Compare With Clipboard", AllIcons.Diff.Diff);
        this.myTable = table;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        int row = this.myTable.getSelectedRow();
        Transferable contents = CopyPasteManager.getInstance().getContents();
        e.getPresentation().setEnabled(project != null && row >= 0 && this.myTable.getValueAt(row, 0) != null && contents != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        String value = this.myTable.getValueAt(row, 0).toString();
        ContentDiffRequest request = DiffRequestFactory.getInstance().createClipboardVsValue(value);
        DiffManager.getInstance().showDiff(project, (DiffRequest)request);
    }
}

