/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8StackTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.StackTraceTable;
import com.jetbrains.nodejs.run.profile.cpu.view.StatisticsTreeTableWithDetails;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import icons.NodeJSIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SearchInV8TreeAction
extends DumbAwareAction {
    private final Project myProject;
    private final StatisticsTreeTableWithDetails myMainComponent;
    private final V8LogCachingReader myReader;
    @NotNull
    private final Factory<Searcher> mySearcherFactory;
    @NonNls
    public static final String SEARCH_ID = "Node.js.profiling.cpu.search.history";

    public SearchInV8TreeAction(Project project, StatisticsTreeTableWithDetails component, V8LogCachingReader reader, @NotNull Factory<Searcher> searcherFactory) {
        if (searcherFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcherFactory", "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction", "<init>"));
        }
        super("Search", "Search", AllIcons.Actions.Search);
        this.myProject = project;
        this.myMainComponent = component;
        this.myReader = reader;
        this.mySearcherFactory = searcherFactory;
    }

    public void actionPerformed(AnActionEvent e) {
        V8ProfilingCallTreeTable table = this.myMainComponent.getTable();
        String text = SearchInV8TreeAction.getSearchString();
        if (!StringUtil.isEmptyOrSpaces((String)text)) {
            Searcher searcher = (Searcher)this.mySearcherFactory.create();
            if (!searcher.search(text.trim(), false)) {
                NodeUIUtil.balloonInfo((Project)this.myProject, (String)("Nothing found by search string '" + text + "'"), (Point)table.getLocationOnScreen(), null);
                return;
            }
            try {
                V8StackTableModel model = new V8StackTableModel(this.myProject, this.myReader, searcher.getUniqueCalls(), searcher.getNumbersOfCalls()).changeLastColumn(new RightAlignedRenderer(), "Number");
                StackTraceTable stackTraceTable = new StackTraceTable(this.myProject, model);
                V8Utils.adjustTableColumnWidths(stackTraceTable);
                DefaultActionGroup tableGroup = new DefaultActionGroup();
                V8Utils.LightweightEditSourceAction editSourceAction = new V8Utils.LightweightEditSourceAction((JComponent)((Object)stackTraceTable));
                tableGroup.add((AnAction)editSourceAction);
                tableGroup.add(this.createNavigateToMainTreeAction(stackTraceTable, searcher));
                PopupHandler.installPopupHandler((JComponent)((Object)stackTraceTable), (ActionGroup)tableGroup, (String)"V8_CPU_PROFILING_POPUP", (ActionManager)ActionManager.getInstance());
                this.myMainComponent.addDetails((JComponent)((Object)stackTraceTable), null, "Search Results for '" + text + "'", true);
                stackTraceTable.addRowSelectionInterval(0, 0);
                stackTraceTable.requestFocus();
            }
            catch (IOException e1) {
                NodeUIUtil.balloonInfo((Project)this.myProject, (String)("Error when opening search results: " + e1.getMessage()), (Point)table.getLocationOnScreen(), null);
            }
        }
    }

    private static String getSearchString() {
        SearchTextFieldWithStoredHistory searchField = new SearchTextFieldWithStoredHistory(SEARCH_ID){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                return new Dimension(150, size.height);
            }
        };
        searchField.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        DialogBuilder builder = new DialogBuilder();
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        panel.add((Component)new JBLabel("Search for:"), (Object)"West");
        panel.add((Component)searchField, (Object)"East");
        builder.setTitle("Search in V8 CPU Profiling Log");
        builder.centerPanel((JComponent)panel).setDimensionServiceKey(SEARCH_ID);
        builder.setPreferredFocusComponent((JComponent)searchField);
        if (!builder.showAndGet()) {
            return null;
        }
        searchField.addCurrentTextToHistory();
        return searchField.getText();
    }

    private AnAction createNavigateToMainTreeAction(final @NotNull StackTraceTable stackTable, final Searcher searcher) {
        if (stackTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackTable", "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction", "createNavigateToMainTreeAction"));
        }
        return new DumbAwareAction("Show In Tree", "Show In Tree", NodeJSIcons.Navigate_inMainTree){

            public void actionPerformed(AnActionEvent e) {
                V8CpuLogCall call = stackTable.getCall();
                if (call == null) {
                    return;
                }
                SearchInV8TreeAction.showCallsInTree(searcher, call, SearchInV8TreeAction.this.myMainComponent);
            }

            public void update(AnActionEvent e) {
                super.update(e);
                Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
                boolean enabled = project != null && stackTable.getCall() != null;
                e.getPresentation().setEnabled(enabled);
            }
        };
    }

    public static void showCallsInTree(@NotNull Searcher searcher, @NotNull V8CpuLogCall call, @NotNull StatisticsTreeTableWithDetails mainComponent) {
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction", "showCallsInTree"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction", "showCallsInTree"));
        }
        if (mainComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainComponent", "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction", "showCallsInTree"));
        }
        V8ProfilingCallTreeTable table = mainComponent.getTable();
        V8Utils.collapseAllBare(table);
        table.getTree().expandPath(new TreePath(table.getTree().getModel().getRoot()));
        List<TreePath> paths = searcher.getPathsToExpand(call);
        V8ProfilingCallTreeComponent.resetDataToTable(table, () -> {
            for (TreePath path : paths) {
                table.getTree().expandPath(path.getParentPath());
            }
        }, () -> {
            if (mainComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainComponent", "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction", "lambda$showCallsInTree$1"));
            }
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction", "lambda$showCallsInTree$1"));
            }
            mainComponent.showSpeedSearch(call);
        });
    }

    public static interface Searcher {
        public boolean search(@NotNull String var1, boolean var2);

        public List<V8CpuLogCall> getUniqueCalls();

        public List<Long> getNumbersOfCalls();

        public List<TreePath> getPathsToExpand(@NotNull V8CpuLogCall var1);
    }
}

