/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.FlatTopCalls;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CodeScope;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameColors;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.PieChartDiagram;
import com.jetbrains.nodejs.run.profile.cpu.view.PieChartLegend;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopCallsSelfDiagram {
    private static final int THRESHOLD = 10;
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8LogCachingReader myReader;
    private final List<Piece> myLines;
    private final LineColorProvider myFileColor;
    private final int myHeight;
    private JComponent myComponent;

    public TopCallsSelfDiagram(@NotNull Project project, @NotNull V8LogCachingReader reader, LineColorProvider fileColor, int height) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsSelfDiagram", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsSelfDiagram", "<init>"));
        }
        this.myProject = project;
        this.myReader = reader;
        this.myFileColor = fileColor;
        this.myHeight = height;
        this.myLines = new ArrayList<Piece>();
        this.fillData(reader);
        this.createUI();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private void createUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        Convertor<Piece, Integer> dataConvertor = new Convertor<Piece, Integer>(){

            public Integer convert(Piece o) {
                return o.getTensPercent();
            }
        };
        Convertor<Piece, JBColor> colorConvertor = new Convertor<Piece, JBColor>(){

            public JBColor convert(Piece o) {
                return o.getColor();
            }
        };
        PieChartDiagram<Piece> pie = new PieChartDiagram<Piece>(this.myHeight, this.myLines, dataConvertor, colorConvertor).withHoleCoeff(0.5);
        PieChartLegend<Piece> legend = new PieChartLegend<Piece>(this.myLines, dataConvertor, colorConvertor, (TableCellRenderer)((Object)new FirstTableCellRenderer()), (TableCellRenderer)((Object)new RightAlignedRenderer().setDefaultBackground(UIUtil.getPanelBackground())));
        GridBagConstraints gb = new GridBagConstraints();
        gb.anchor = 18;
        gb.fill = 0;
        gb.insets = new Insets(5, 5, 5, 5);
        panel.add(pie, gb);
        ++gb.gridy;
        panel.add(legend, gb);
        this.myComponent = new JPanel(new BorderLayout());
        JBLabel title = new JBLabel(NodeJSBundle.message("node.js.v8.cpu.top.calls.overview.description", new Object[0]));
        title.setBorder(JBUI.Borders.empty((int)3));
        JPanel titleWrapper = TopCallsSelfDiagram.createNorthWrapper((JComponent)title);
        titleWrapper.add((Component)TopCallsSelfDiagram.createNorthWrapper(panel), "West");
        this.myComponent.add((Component)titleWrapper, "West");
    }

    @NotNull
    private static JPanel createNorthWrapper(JComponent component) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)component, "North");
        JPanel jPanel = wrapper;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsSelfDiagram", "createNorthWrapper"));
        }
        return jPanel;
    }

    private void fillData(@NotNull V8LogCachingReader reader) throws IOException {
        int gcPercent;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsSelfDiagram", "fillData"));
        }
        long total = reader.getNumTicks();
        int idlePercent = V8Utils.tensPercent(reader.getNumIdleTicks(), total);
        if (idlePercent >= 10) {
            this.myLines.add(new Piece(null, "Idle", idlePercent, FlameColors.IDLE_COLOR));
        }
        if ((gcPercent = V8Utils.tensPercent(reader.getNumGcTicks(), total)) >= 10) {
            this.myLines.add(new Piece(null, "GC", gcPercent, FlameColors.getColor(0L, V8CodeScope.gc)));
        }
        FlatTopCalls flat = reader.getFlat();
        this.addLines(flat.getCpp());
        this.addLines(flat.getJavaScript());
        this.addLines(flat.getSharedLibraries());
        this.sortAndAddOther();
    }

    private void sortAndAddOther() {
        int total = 0;
        for (Piece line : this.myLines) {
            total += line.getTensPercent();
        }
        if ((total = 1000 - total) > 1) {
            this.myLines.add(new Piece(null, "Other", total, FlameColors.OTHER_COLOR));
        }
        Collections.sort(this.myLines, (o1, o2) -> new Integer(o1.getTensPercent()).compareTo(o2.getTensPercent()));
    }

    private void addLines(List<V8ProfileLine> list) throws IOException {
        for (V8ProfileLine line : list) {
            if (line.getSelfTensPercent() < 10) continue;
            long id = line.getCall().getStringId();
            Piece piece = new Piece(line, null, line.getSelfTensPercent(), FlameColors.getColor(id, this.myReader.getCodeScopeByStringId(id)));
            this.myLines.add(piece);
        }
    }

    private static class Piece {
        @Nullable
        private final V8ProfileLine myLine;
        @Nullable
        private final String myPresentation;
        private int myTensPercent;
        private final JBColor myColor;

        public Piece(@Nullable V8ProfileLine line, String presentation, int tensPercent, JBColor color) {
            this.myLine = line;
            this.myPresentation = presentation;
            this.myTensPercent = tensPercent;
            this.myColor = color;
        }

        @Nullable
        public V8ProfileLine getLine() {
            return this.myLine;
        }

        public String getPresentation() {
            return this.myPresentation;
        }

        public int getTensPercent() {
            return this.myTensPercent;
        }

        public void setTensPercent(int tensPercent) {
            this.myTensPercent = tensPercent;
        }

        public JBColor getColor() {
            return this.myColor;
        }
    }

    private static class FirstTableCellRenderer
    extends ColoredTableCellRenderer {
        private FirstTableCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setBackground(UIUtil.getPanelBackground());
            if (value instanceof Piece) {
                if (((Piece)value).getLine() != null) {
                    V8CpuLogCall call = ((Piece)value).getLine().getCall();
                    V8ProfileLineTreeCellRenderer.Attributes attributes = V8ProfileLineTreeCellRenderer.getAttributes(call.isLocal(), call.isNative() || call.isNotNavigatable());
                    this.append(call.getPresentation(false), attributes.getAttributes(false));
                } else {
                    this.append(((Piece)value).getPresentation());
                }
            } else if (value != null) {
                this.append(value.toString());
            }
        }
    }
}

