/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TimeDistribution;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.ZoomFlameChartAnAction;
import icons.NodeJSIcons;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class V8NavigateToFlameChartIntervalAction
extends DumbAwareAction {
    @NotNull
    private final Kind myKind;
    private final V8LogCachingReader myReader;
    private final Consumer<String> myNotificator;

    public V8NavigateToFlameChartIntervalAction(@NotNull Kind kind, V8LogCachingReader reader, Consumer<String> notificator) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/nodejs/run/profile/cpu/view/V8NavigateToFlameChartIntervalAction", "<init>"));
        }
        super(V8NavigateToFlameChartIntervalAction.name(kind), V8NavigateToFlameChartIntervalAction.name(kind), NodeJSIcons.Navigate_inMainTree);
        this.myKind = kind;
        this.myReader = reader;
        this.myNotificator = notificator;
    }

    public static void addToGroup(DefaultActionGroup group, V8LogCachingReader reader, Consumer<String> notificator) {
        for (Kind kind : Kind.values()) {
            group.add((AnAction)new V8NavigateToFlameChartIntervalAction(kind, reader, notificator));
        }
    }

    @NotNull
    private static String name(@NotNull Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/jetbrains/nodejs/run/profile/cpu/view/V8NavigateToFlameChartIntervalAction", "name"));
        }
        String string = "Navigate To " + kind.getText() + " Time";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/view/V8NavigateToFlameChartIntervalAction", "name"));
        }
        return string;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(V8Utils.SELECTED_CALL.getData(e.getDataContext()) != null && PlatformDataKeys.PROJECT.getData(e.getDataContext()) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        V8CpuLogCall call = (V8CpuLogCall)V8Utils.SELECTED_CALL.getData(e.getDataContext());
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (call == null || project == null) {
            return;
        }
        try {
            long start;
            long interval;
            boolean takeLongest;
            TimeDistribution distribution = this.myKind.mySelf ? this.myReader.getSelfTimesDistribution(call.getStringId()) : this.myReader.getTimesDistribution(call.getStringId());
            if (distribution == null || distribution.isEmpty()) {
                String message = "Cannot navigate to the Flame Chart: " + (this.myKind.mySelf ? "the call has not been recorded at the stack top." : "data not found.");
                NodeUIUtil.balloonInfo((Project)project, (String)message, null, null);
                return;
            }
            boolean bl = takeLongest = this.myKind.myLongest || distribution.getTypicalIndex() == -1;
            if (takeLongest) {
                interval = distribution.getMax();
                start = distribution.getMaxStartTs();
            } else {
                int index = distribution.getTypicalIndex();
                interval = distribution.getEndTimes()[index];
                start = distribution.getSampleStartTs()[index];
            }
            long selectionStart = (long)Math.max(0.0, (double)start - (double)interval * 0.5);
            long selectionEnd = start + interval * 2L;
            long selected = selectionEnd - selectionStart;
            long showStart = Math.max(0L, selectionStart - selected * 4L);
            long showEnd = selectionStart + selected * 5L;
            ZoomFlameChartAnAction.ZoomTask task = new ZoomFlameChartAnAction.ZoomTask(project, this.myReader, this.myReader.getV8LogFile().getName(), this.myNotificator, (BeforeAfter<Long>)new BeforeAfter((Object)showStart, (Object)showEnd)).withDetailsPosition(start + interval / 4L).withStringId(call.getStringId()).withSelection(selectionStart, selectionEnd);
            ProgressManager.getInstance().run((Task)task);
        }
        catch (IOException e1) {
            NodeUIUtil.balloonInfo((Project)project, (String)("Can not navigate to Flame Chart: " + e1.getMessage()), null, null);
        }
    }

    public static enum Kind {
        longestTotal("Longest", true, false),
        typicalTotal("Typical", false, false),
        longestSelf("Longest Self", true, true),
        typicalSelf("Typical Self", false, true);

        private final String myText;
        private final boolean myLongest;
        private final boolean mySelf;

        private Kind(String text, boolean longest, boolean self) {
            this.myText = text;
            this.myLongest = longest;
            this.mySelf = self;
        }

        public String getText() {
            return this.myText;
        }
    }
}

