/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreeType;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.view.FilteredByPercent;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ColumnForNumbers;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8TreeTableModel
implements FilteredByPercent,
TreeTableModelWithCustomRenderer {
    public static final int SELF_THRESHOLD = 100;
    public static final int TOTAL_THRESHOLD = 100;
    private final V8ProfileLine myRoot;
    @NotNull
    private final CallTreeType myCallTreeType;
    private final ColumnInfo[] myColumns;
    private final V8ProfileLineTreeCellRenderer<V8ProfileLine> myZeroCellRenderer;
    private V8ProfileLine myFiltered;
    private int myTensPercentLevelInclusive;

    private static List<ColumnInfo> createBottomUpColumns(@NotNull Processor<V8ProfileLine> processor, @NotNull V8ProfileLineTreeCellRenderer renderer) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "createBottomUpColumns"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "createBottomUpColumns"));
        }
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        list.add(new V8ProfileLineV8ProfileLineColumnInfo(renderer));
        V8ColumnForNumbers<V8ProfileLine> ticks = new V8ColumnForNumbers<V8ProfileLine>("Ticks", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return String.valueOf(line.getTotalTicks());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> ofParent = new V8ColumnForNumbers<V8ProfileLine>("of parent", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return V8Utils.formatPercent(line.getTotalTensPercent());
            }
        };
        list.add(ticks);
        list.add(ofParent);
        return list;
    }

    private static List<ColumnInfo> createTopDownColumns(@NotNull Processor<V8ProfileLine> processor, @NotNull V8ProfileLineTreeCellRenderer renderer) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "createTopDownColumns"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "createTopDownColumns"));
        }
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        list.add(new V8ProfileLineV8ProfileLineColumnInfo(renderer));
        V8ColumnForNumbers<V8ProfileLine> totalPercent = new V8ColumnForNumbers<V8ProfileLine>("Total %", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return V8Utils.formatPercent(line.getTotalTensPercent());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> self = new V8ColumnForNumbers<V8ProfileLine>("Self %", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return V8Utils.formatPercent(line.getSelfTensPercent());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> total = new V8ColumnForNumbers<V8ProfileLine>("Total", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return String.valueOf(line.getTotalTicks());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> selfTicks = new V8ColumnForNumbers<V8ProfileLine>("Self", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return String.valueOf(line.getSelfTicks());
            }
        };
        list.add(total);
        list.add(totalPercent);
        list.add(selfTicks);
        list.add(self);
        return list;
    }

    public V8TreeTableModel(@NotNull V8ProfileLine root, @NotNull CallTreeType callTreeType, @NotNull LineColorProvider fileColors) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "<init>"));
        }
        if (callTreeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTreeType", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "<init>"));
        }
        if (fileColors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileColors", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "<init>"));
        }
        this.myTensPercentLevelInclusive = 0;
        this.myRoot = root;
        this.myCallTreeType = callTreeType;
        Processor processor = value -> V8TreeTableModel.v8LineIsAboveThresholds(value) && (CallTreeType.topDown.equals((Object)this.myCallTreeType) || value.getParent() != null && value.getParent().getParent() == null);
        this.myZeroCellRenderer = new V8ProfileLineTreeCellRenderer<V8ProfileLine>(processor, fileColors){

            @Override
            protected V8CpuLogCall getCall(Object object) {
                if (!(object instanceof V8ProfileLine)) {
                    return null;
                }
                return ((V8ProfileLine)object).getCall();
            }
        };
        List<ColumnInfo> listColumns = CallTreeType.bottomUp.equals((Object)callTreeType) ? V8TreeTableModel.createBottomUpColumns((Processor<V8ProfileLine>)processor, this.myZeroCellRenderer) : V8TreeTableModel.createTopDownColumns((Processor<V8ProfileLine>)processor, this.myZeroCellRenderer);
        this.myColumns = listColumns.toArray(new ColumnInfo[listColumns.size()]);
    }

    public V8ProfileLineTreeCellRenderer getZeroCellRenderer() {
        return this.myZeroCellRenderer;
    }

    @Override
    public boolean isFiltered() {
        return this.myFiltered != null;
    }

    @Override
    public int getTensPercentLevelInclusive() {
        return this.myTensPercentLevelInclusive;
    }

    @Override
    public void clearFilter() {
        this.myTensPercentLevelInclusive = 0;
        this.myFiltered = null;
    }

    @Override
    public void filterByLevel(final int tensPercentLevelInclusive) {
        this.myTensPercentLevelInclusive = tensPercentLevelInclusive;
        Predicate<V8ProfileLine> predicate = new Predicate<V8ProfileLine>(){

            public boolean apply(@Nullable V8ProfileLine input) {
                return input.getTotalTensPercent() >= tensPercentLevelInclusive;
            }
        };
        this.myFiltered = new V8ProfileLine(-1, -1, -1, -1, null, 0, "", -1L);
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        for (V8ProfileLine line : this.myRoot.getChildren()) {
            if (!predicate.apply((Object)line)) continue;
            queue.add(Pair.create((Object)this.myFiltered, (Object)line));
        }
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (!predicate.apply(pair.getSecond())) continue;
            V8ProfileLine copy = ((V8ProfileLine)pair.getSecond()).cloneWithoutChildren((V8ProfileLine)pair.getFirst());
            List<V8ProfileLine> children = ((V8ProfileLine)pair.getSecond()).getChildren();
            for (V8ProfileLine child : children) {
                queue.add(Pair.create((Object)copy, (Object)child));
            }
        }
    }

    public List<V8ProfileLine> search(@NotNull String s, boolean caseSensitive) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "search"));
        }
        ArrayList<V8ProfileLine> list = new ArrayList<V8ProfileLine>();
        ArrayDeque<V8ProfileLine> queue = new ArrayDeque<V8ProfileLine>();
        queue.add(this.myRoot);
        while (!queue.isEmpty()) {
            boolean matches;
            V8ProfileLine line = (V8ProfileLine)queue.removeFirst();
            String presentation = line.getPresentation(false);
            boolean bl = matches = caseSensitive ? presentation.contains(s) : presentation.toLowerCase().contains(s.toLowerCase());
            if (matches) {
                list.add(line);
            }
            queue.addAll(line.getChildren());
        }
        return list;
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
        throw new UnsupportedOperationException();
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myFiltered != null ? this.myFiltered : this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        return ((V8ProfileLine)parent).getChildren().get(index);
    }

    public int getChildCount(Object parent) {
        return ((V8ProfileLine)parent).getChildren().size();
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        List<V8ProfileLine> children = ((V8ProfileLine)parent).getChildren();
        for (int i = 0; i < children.size(); ++i) {
            V8ProfileLine current = children.get(i);
            if (!child.equals(current)) continue;
            return i;
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Nullable
    public TreePath createSelectionPathForStackTrace(@NotNull List<Long> stack) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "createSelectionPathForStackTrace"));
        }
        List<Object> nodesList = V8TreeTableModel.findPath(stack, (V8ProfileLine)this.getRoot());
        if (nodesList.size() <= stack.size() && this.myFiltered != null && (nodesList = V8TreeTableModel.findPath(stack, this.myRoot)).size() > 1) {
            this.clearFilter();
        }
        if (nodesList.size() == 1) {
            return null;
        }
        return new TreePath(ArrayUtil.toObjectArray(nodesList));
    }

    @NotNull
    private static List<Object> findPath(@NotNull List<Long> stack, V8ProfileLine root) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "findPath"));
        }
        ArrayList<Object> nodesList = new ArrayList<Object>();
        V8ProfileLine line = root;
        nodesList.add(line);
        for (Long stringId : stack) {
            List<V8ProfileLine> children = line.getChildren();
            V8ProfileLine found = null;
            for (V8ProfileLine child : children) {
                if (child.getCall().getStringId() != stringId.longValue()) continue;
                line = found = child;
                break;
            }
            if (found == null) break;
            nodesList.add(found);
        }
        ArrayList<Object> arrayList = nodesList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel", "findPath"));
        }
        return arrayList;
    }

    static boolean v8LineIsAboveThresholds(V8ProfileLine line) {
        return line.getSelfTensPercent() >= 100 || line.getTotalTensPercent() >= 100;
    }

    public static class V8ProfileLineV8ProfileLineColumnInfo
    extends ColumnInfo<V8ProfileLine, V8ProfileLine> {
        private ColoredTreeCellRenderer myRenderer;

        public V8ProfileLineV8ProfileLineColumnInfo(@NotNull V8ProfileLineTreeCellRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel$V8ProfileLineV8ProfileLineColumnInfo", "<init>"));
            }
            super("Calls");
            this.myRenderer = renderer;
        }

        @Nullable
        public V8ProfileLine valueOf(V8ProfileLine line) {
            return line;
        }

        public TableCellRenderer getCustomizedRenderer(V8ProfileLine line, TableCellRenderer renderer) {
            if (renderer instanceof TreeTableCellRenderer) {
                ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)this.myRenderer);
            }
            return renderer;
        }
    }
}

