/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class FileSorter<T> {
    private static final long PACK_SIZE = 10000L;
    private long myPackSize;
    private final RawSerializer<T> mySerializer;
    private final File myInFile;
    @NotNull
    private final Comparator<T> myComparator;
    private File myOutFile;
    private final ArrayDeque<File> myTmpFiles;
    private Processor<T> myFilter;

    public FileSorter(@NotNull RawSerializer<T> serializer, @NotNull File inFile, @NotNull Comparator<T> comparator) throws IOException {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/jetbrains/nodejs/run/profile/heap/FileSorter", "<init>"));
        }
        if (inFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inFile", "com/jetbrains/nodejs/run/profile/heap/FileSorter", "<init>"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/jetbrains/nodejs/run/profile/heap/FileSorter", "<init>"));
        }
        this.mySerializer = serializer;
        this.myInFile = inFile;
        this.myComparator = comparator;
        this.myTmpFiles = new ArrayDeque();
        this.myPackSize = 10000L;
    }

    public void setFilter(Processor<T> filter) {
        this.myFilter = filter;
    }

    public void setPackSize(long packSize) {
        this.myPackSize = packSize;
    }

    public void sort() throws IOException {
        this.sortParts();
        this.connectParts();
    }

    private void connectParts() throws IOException {
        if (this.myTmpFiles.isEmpty()) {
            this.myOutFile = this.myInFile;
            return;
        }
        while (this.myTmpFiles.size() > 1) {
            File first = this.myTmpFiles.removeFirst();
            File second = this.myTmpFiles.removeFirst();
            this.myTmpFiles.add(this.connectTwo(first, second));
        }
        this.myOutFile = this.myTmpFiles.removeFirst();
        FileUtil.delete((File)this.myInFile);
        FileUtil.rename((File)this.myOutFile, (File)this.myInFile);
        this.myOutFile = this.myInFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File connectTwo(@NotNull File first, @NotNull File second) throws IOException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/jetbrains/nodejs/run/profile/heap/FileSorter", "connectTwo"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/jetbrains/nodejs/run/profile/heap/FileSorter", "connectTwo"));
        }
        File tmp = FileUtil.createTempFile((String)"sort", null, (boolean)false);
        SequentialRawWriter<T> writer = new SequentialRawWriter<T>(tmp, this.mySerializer);
        SequentialRawReader<T> readerOne = new SequentialRawReader<T>(first, this.mySerializer);
        SequentialRawReader<T> readerTwo = new SequentialRawReader<T>(second, this.mySerializer);
        try {
            T one = readerOne.read();
            T two = readerTwo.read();
            while (true) {
                if (this.myComparator.compare(one, two) < 0) {
                    writer.write(one);
                    if (!readerOne.hasNext()) {
                        writer.write(two);
                        break;
                    }
                    one = readerOne.read();
                    continue;
                }
                writer.write(two);
                if (!readerTwo.hasNext()) {
                    writer.write(one);
                    break;
                }
                two = readerTwo.read();
            }
            while (readerOne.hasNext()) {
                writer.write(readerOne.read());
            }
            while (readerTwo.hasNext()) {
                writer.write(readerTwo.read());
            }
        }
        finally {
            writer.close();
            readerOne.close();
            readerTwo.close();
            FileUtil.delete((File)first);
            FileUtil.delete((File)second);
        }
        return tmp;
    }

    public File getOutFile() {
        return this.myOutFile;
    }

    private void sortParts() throws IOException {
        try (SequentialRawReader<T> reader = new SequentialRawReader<T>(this.myInFile, this.mySerializer);){
            while (reader.hasNext()) {
                this.sortPart(reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortPart(SequentialRawReader<T> reader) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        while ((long)list.size() <= this.myPackSize && reader.hasNext()) {
            T item = reader.read();
            if (this.myFilter != null && !this.myFilter.process(item)) continue;
            list.add(item);
        }
        Collections.sort(list, this.myComparator);
        File tmp = FileUtil.createTempFile((String)"sort", null, (boolean)false);
        try (SequentialRawWriter writer = new SequentialRawWriter(tmp, this.mySerializer);){
            for (Object t : list) {
                writer.write(t);
            }
            this.myTmpFiles.add(tmp);
        }
    }
}

