/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.heap.view.main.OpenSnapshotWorker;
import com.jetbrains.nodejs.run.profile.heap.view.main.SaveSnapshotDialog;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import icons.NodeJSIcons;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TakeHeapSnapshotAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.NodeJSDebugProcessWithProfiling");
    private static final int TIMEOUT = (int)TimeUnit.MINUTES.toMillis(3L);
    @NonNls
    public static final String V_8_HEAP = "v8heap";
    private static final String USAGE_KEY = "node.js.v8.profiling.take.heap.snapshot";
    private final Map<Integer, File> myTakenSnapshots;
    @NonNls
    public static final String SNAPSHOT = "snapshot";
    private final Project myProject;
    private final long myPort;
    private final String myConfigurationName;
    private final String myNodeInterpreterPath;
    private final String myWorkingDirectory;
    private final NodeFileTransfer myFileTransfer;
    private int myCnt;
    private volatile boolean myIsDisposed;
    private final String myHost;

    /*
     * WARNING - void declaration
     */
    public TakeHeapSnapshotAction(@NotNull Project project, @Nullable String host, long port, String configurationName, String nodeInterpreterPath, String workingDirectory, NodeFileTransfer nodeFileTransfer) {
        void fileTransfer;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction", "<init>"));
        }
        super(NodeJSBundle.message("node.js.v8.heap.take.snapshot.action.text", new Object[0]), NodeJSBundle.message("node.js.v8.heap.take.snapshot.action.description", new Object[0]), NodeJSIcons.TakeHeapSnapshot);
        this.myProject = project;
        this.myHost = host == null ? "localhost" : host;
        this.myPort = port;
        this.myConfigurationName = configurationName;
        this.myNodeInterpreterPath = nodeInterpreterPath;
        this.myWorkingDirectory = workingDirectory;
        this.myFileTransfer = fileTransfer;
        this.myTakenSnapshots = new HashMap<Integer, File>();
        this.myCnt = 0;
        this.myIsDisposed = false;
    }

    public void setDisposed() {
        this.myIsDisposed = true;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(!this.myIsDisposed);
    }

    public void actionPerformed(AnActionEvent e) {
        UsageTrigger.trigger((String)USAGE_KEY);
        ApplicationManager.getApplication().invokeLater(() -> {
            FileSaverDescriptor descriptor = new FileSaverDescriptor(this.myConfigurationName, "Select a location to save a V8 heap snapshot to.", new String[]{"heapsnapshot"});
            SaveSnapshotDialog dialog = new SaveSnapshotDialog(descriptor, this.myProject);
            VirtualFileWrapper wrapper = dialog.save(this.myProject.getBaseDir(), TakeHeapSnapshotAction.suggestFileName(this.myConfigurationName));
            if (wrapper == null) {
                return;
            }
            if (!TakeHeapSnapshotAction.checkFilePath(this.myProject, wrapper)) {
                return;
            }
            File file = wrapper.getFile();
            this.takeSnapshot(dialog.openCreatedSnapshot(), dialog.showHiddenData(), wrapper, file);
        });
    }

    private void takeSnapshot(final boolean openSnapshot, final boolean showHiddenData, final VirtualFileWrapper wrapper, final File file) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Taking V8 heap snapshot...", true, null){
            private boolean myErrorReported;
            {
                super(arg0, arg1, arg2, arg3);
                this.myErrorReported = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction$1", "run"));
                }
                try {
                    String snapshotPath = file.getAbsolutePath();
                    if (!TakeHeapSnapshotAction.this.myFileTransfer.isLocal()) {
                        String dirPath = TakeHeapSnapshotAction.this.myFileTransfer.getMappingFor(TakeHeapSnapshotAction.this.myWorkingDirectory);
                        if (TakeHeapSnapshotAction.this.myFileTransfer.mkDir(dirPath, TakeHeapSnapshotAction.V_8_HEAP)) {
                            dirPath = dirPath + "/v8heap";
                        }
                        snapshotPath = TakeHeapSnapshotAction.this.myFileTransfer.getPathForTempFile(dirPath, file.getName());
                    }
                    UUID uuid = UUID.randomUUID();
                    if (TakeHeapSnapshotAction.sendCommand(TakeHeapSnapshotAction.this.myHost, TakeHeapSnapshotAction.this.myPort, "takeHeapSnapshot/?filePath=\"" + snapshotPath + "\"&uuid=" + uuid)) {
                        long start = System.currentTimeMillis();
                        while (System.currentTimeMillis() - (long)TIMEOUT < start) {
                            if (TakeHeapSnapshotAction.sendCommand(TakeHeapSnapshotAction.this.myHost, TakeHeapSnapshotAction.this.myPort, "status/?uuid=" + uuid)) {
                                if (!TakeHeapSnapshotAction.this.myFileTransfer.isLocal()) {
                                    TakeHeapSnapshotAction.this.myFileTransfer.fetch(snapshotPath, file.getAbsolutePath());
                                }
                                if (wrapper.getFile().exists()) {
                                    TakeHeapSnapshotAction.this.myTakenSnapshots.put(TakeHeapSnapshotAction.this.myCnt++, file);
                                }
                                return;
                            }
                            Thread.sleep(100L);
                        }
                    }
                    this.myErrorReported = true;
                    NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Timeout occurred when saving heap snapshot.", MessageType.ERROR).notify(this.myProject);
                }
                catch (Exception e1) {
                    LOG.info((Throwable)e1);
                    this.myErrorReported = true;
                    NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Can not send 'take snapshot' command: " + e1.getMessage(), MessageType.ERROR).notify(this.myProject);
                }
            }

            public void onSuccess() {
                if (!wrapper.getFile().exists() || wrapper.getVirtualFile() == null) {
                    if (!this.myErrorReported) {
                        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Heap snapshot wasn't saved.", MessageType.ERROR).notify(this.myProject);
                    }
                    return;
                }
                NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Heap snapshot was saved to " + TakeHeapSnapshotAction.filePathText(wrapper), MessageType.INFO).notify(this.myProject);
                if (openSnapshot) {
                    OpenSnapshotWorker.work(this.myProject, wrapper.getVirtualFile(), showHiddenData);
                }
            }
        });
    }

    @NotNull
    private static String filePathText(VirtualFileWrapper wrapper) {
        File file = wrapper.getFile();
        String string = file.getName() + (file.getParentFile() != null ? " (" + file.getParentFile().getAbsolutePath() + ")" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction", "filePathText"));
        }
        return string;
    }

    private static String suggestFileName(String name) {
        String suggested = name.replace("\\", "/");
        if ((suggested = StringUtil.trimEnd((String)suggested, (String)"/")).length() == 0) {
            return SNAPSHOT;
        }
        int idx = suggested.lastIndexOf(47);
        if (idx > 0 && (suggested = suggested.substring(idx + 1)).length() == 0) {
            return SNAPSHOT;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < suggested.length(); ++i) {
            char c = suggested.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static boolean checkFilePath(Project project, VirtualFileWrapper wrapper) {
        String message = null;
        try {
            if (wrapper.getFile().exists()) {
                return true;
            }
            if (wrapper.getFile().createNewFile()) {
                FileUtil.delete((File)wrapper.getFile());
                return true;
            }
        }
        catch (IOException e1) {
            message = e1.getMessage();
        }
        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Can not create file '" + wrapper.getFile().getAbsolutePath() + "'. " + StringUtil.notNullize((String)message), MessageType.ERROR).notify(project);
        return false;
    }

    public static boolean sendCommand(String host, long port, String command) throws IOException {
        String url = V8Utils.encodeUrl("http://" + host + ":" + port + "/" + command);
        String content = HttpRequests.request((String)url).connectTimeout(TIMEOUT).readTimeout(TIMEOUT).readString(ProgressManager.getInstance().getProgressIndicator());
        return "ok".equalsIgnoreCase(content);
    }
}

