/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.SizeOffset;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AggregatesPortionBuilder {
    private final V8CachingReader myReader;
    @NotNull
    private final Flags myFlags;
    private final boolean myShowHiddenData;
    private final Map<Long, Aggregate> myAggregates;
    private final Map<Integer, List<Long>> myLinks;
    private final long myFromClassIdx;
    private final long myToClassIdx;
    private final int myIdxOffset;
    private final TIntArrayList myDistances;
    private final TIntArrayList myUnreachable;
    private long myOffset;

    /*
     * WARNING - void declaration
     */
    public AggregatesPortionBuilder(@NotNull V8CachingReader reader, @NotNull Flags flags, boolean showHiddenData, long fromClassIdx, long toClassIdx, int idxOffset, TIntArrayList tIntArrayList, TIntArrayList tIntArrayList2) {
        void unreachable;
        void distances;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/calculation/AggregatesPortionBuilder", "<init>"));
        }
        if (flags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flags", "com/jetbrains/nodejs/run/profile/heap/calculation/AggregatesPortionBuilder", "<init>"));
        }
        this.myReader = reader;
        this.myFlags = flags;
        this.myShowHiddenData = showHiddenData;
        this.myFromClassIdx = fromClassIdx;
        this.myToClassIdx = toClassIdx;
        this.myIdxOffset = idxOffset;
        this.myDistances = distances;
        this.myUnreachable = unreachable;
        this.myAggregates = new HashMap<Long, Aggregate>();
        this.myLinks = new HashMap<Integer, List<Long>>();
        this.myOffset = 0L;
    }

    public void calculate(final @NotNull SequentialRawWriter<SizeOffset> numsWriter, final @NotNull SequentialRawWriter<Long> linksWriter) throws IOException {
        if (numsWriter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numsWriter", "com/jetbrains/nodejs/run/profile/heap/calculation/AggregatesPortionBuilder", "calculate"));
        }
        if (linksWriter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linksWriter", "com/jetbrains/nodejs/run/profile/heap/calculation/AggregatesPortionBuilder", "calculate"));
        }
        SequentialRawReader<V8HeapEntry> reader = new SequentialRawReader<V8HeapEntry>(this.myReader.getNodeIndexFile(), V8HeapEntry.MyRawSerializer.getInstance(), this.myDistances.size());
        reader.iterate(new CloseableThrowableConsumer<V8HeapEntry, IOException>(){

            @Override
            public void close() throws IOException {
                for (int i = AggregatesPortionBuilder.this.myIdxOffset; i < AggregatesPortionBuilder.this.myIdxOffset + AggregatesPortionBuilder.this.myLinks.size(); ++i) {
                    List list = (List)AggregatesPortionBuilder.this.myLinks.get(i);
                    numsWriter.write(new SizeOffset(list.size(), AggregatesPortionBuilder.this.myOffset));
                    AggregatesPortionBuilder.this.myOffset = AggregatesPortionBuilder.this.myOffset + (long)list.size();
                    for (Long link : list) {
                        linksWriter.write(link);
                    }
                }
            }

            public void consume(V8HeapEntry entry) throws IOException {
                AggregatesPortionBuilder.this.additionalProcessing(entry);
                if (!AggregatesPortionBuilder.this.myShowHiddenData && !AggregatesPortionBuilder.this.myFlags.isPage((int)entry.getId())) {
                    return;
                }
                if (!V8HeapNodeType.kNative.equals((Object)entry.getType()) && entry.getSize() == 0L) {
                    return;
                }
                long classIndex = entry.getClassIndex();
                if (classIndex < AggregatesPortionBuilder.this.myFromClassIdx || classIndex > AggregatesPortionBuilder.this.myToClassIdx) {
                    return;
                }
                Aggregate aggregate = (Aggregate)AggregatesPortionBuilder.this.myAggregates.get(classIndex);
                int distance = AggregatesPortionBuilder.this.myDistances.get((int)entry.getId());
                if (aggregate == null) {
                    aggregate = new Aggregate(AggregatesPortionBuilder.this.myIdxOffset + AggregatesPortionBuilder.this.myAggregates.size(), classIndex, distance, entry.getSize(), entry.getType());
                    AggregatesPortionBuilder.this.myAggregates.put(classIndex, aggregate);
                    ArrayList<Long> list = new ArrayList<Long>();
                    list.add(entry.getId());
                    AggregatesPortionBuilder.this.myLinks.put(aggregate.getId(), list);
                } else {
                    aggregate.addSize(entry.getSize());
                    if (distance < aggregate.getDistance()) {
                        aggregate.setDistance(distance);
                    }
                    ((List)AggregatesPortionBuilder.this.myLinks.get(aggregate.getId())).add(entry.getId());
                }
            }
        });
    }

    protected void additionalProcessing(V8HeapEntry entry) {
    }

    public Map<Long, Aggregate> getAggregates() {
        return this.myAggregates;
    }
}

