/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.Processor;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8PostOrderBuilder;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import gnu.trove.TIntArrayList;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DominatorTreeBuilder {
    private TIntArrayList myDominators;
    private TIntArrayList myDominatorsTree;
    private TIntArrayList myAffected;
    private final int myNodesCnt;
    private final V8CachingReader myReader;
    private final V8PostOrderBuilder myPostOrderBuilder;
    @NotNull
    private final Flags myFlags;
    private int myRootPostOrderIndex;
    private V8HeapEntry myRoot;
    private LinksReader<V8HeapEdge> myReverseIndexReader;
    private final boolean myShowHiddenData;

    public DominatorTreeBuilder(int nodesCnt, V8CachingReader reader, V8PostOrderBuilder postOrderBuilder, @NotNull Flags flags, @NotNull LinksReader<V8HeapEdge> linksReader, boolean showHiddenData) throws FileNotFoundException {
        if (flags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flags", "com/jetbrains/nodejs/run/profile/heap/calculation/DominatorTreeBuilder", "<init>"));
        }
        if (linksReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linksReader", "com/jetbrains/nodejs/run/profile/heap/calculation/DominatorTreeBuilder", "<init>"));
        }
        this.myNodesCnt = nodesCnt;
        this.myReader = reader;
        this.myPostOrderBuilder = postOrderBuilder;
        this.myFlags = flags;
        this.myReverseIndexReader = linksReader;
        this.myShowHiddenData = showHiddenData;
        this.myDominators = new TIntArrayList(nodesCnt);
        this.myAffected = new TIntArrayList(nodesCnt);
    }

    private void initDominators(int nodesCnt) {
        this.myRootPostOrderIndex = nodesCnt - 1;
        for (int i = 0; i < this.myRootPostOrderIndex; ++i) {
            this.myDominators.add(nodesCnt);
            this.myAffected.add(0);
        }
        this.myAffected.add(0);
        this.myDominators.add(this.myRootPostOrderIndex);
    }

    public void execute() throws IOException {
        this.initDominators(this.myNodesCnt);
        this.myRoot = this.myReader.getNode(0L);
        for (V8HeapEdge edge : this.myReader.getChildren(this.myRoot)) {
            if (this.weakOrShortcut(edge)) continue;
            this.myAffected.set(this.myPostOrderBuilder.getNodeToPostOrder().get((int)edge.getToIndex()), 1);
        }
        while (this.iteration()) {
        }
        this.myDominatorsTree = new TIntArrayList(this.myNodesCnt);
        for (int i = 0; i < this.myNodesCnt; ++i) {
            this.myDominatorsTree.add(-1);
        }
        for (int postOrderIndex = 0; postOrderIndex < this.myNodesCnt; ++postOrderIndex) {
            int nodeIdx = this.myPostOrderBuilder.getPostOrderToNode().get(postOrderIndex);
            int dominatorByPostOrder = this.myDominators.get(postOrderIndex);
            if (dominatorByPostOrder < this.myNodesCnt) {
                this.myDominatorsTree.set(nodeIdx, this.myPostOrderBuilder.getPostOrderToNode().get(dominatorByPostOrder));
                continue;
            }
            this.myDominatorsTree.set(nodeIdx, 0);
        }
        this.myDominators = null;
        this.myAffected = null;
    }

    public TIntArrayList getDominatorsTree() {
        return this.myDominatorsTree;
    }

    private boolean weakOrShortcut(V8HeapEdge edge) {
        return V8HeapGraphEdgeType.kWeak.equals((Object)edge.getType()) || V8HeapGraphEdgeType.kShortcut.equals((Object)edge.getType());
    }

    private boolean iteration() throws IOException {
        boolean changed = false;
        for (int postOrderIndex = this.myRootPostOrderIndex - 1; postOrderIndex >= 0; --postOrderIndex) {
            if (this.myAffected.get(postOrderIndex) == 0) continue;
            this.myAffected.set(postOrderIndex, 0);
            if (this.myDominators.get(postOrderIndex) == this.myRootPostOrderIndex) continue;
            int nodeIdx = this.myPostOrderBuilder.getPostOrderToNode().get(postOrderIndex);
            final boolean isNodePageObject = this.myFlags.isPage(nodeIdx);
            final int[] newDominatorIndex = new int[]{this.myNodesCnt};
            final boolean[] orphanNode = new boolean[]{true};
            this.myReverseIndexReader.read(nodeIdx, new Processor<V8HeapEdge>(){
                private boolean breakFlag = false;

                public boolean process(V8HeapEdge edge) {
                    if (this.breakFlag) {
                        return false;
                    }
                    if (DominatorTreeBuilder.this.weakOrShortcut(edge)) {
                        return true;
                    }
                    orphanNode[0] = false;
                    boolean retainerFlag = DominatorTreeBuilder.this.myFlags.isPage((int)edge.getFromIndex());
                    if (!DominatorTreeBuilder.this.myShowHiddenData && edge.getFromIndex() != 0L && isNodePageObject && !retainerFlag) {
                        return true;
                    }
                    int retainerPostIndex = DominatorTreeBuilder.this.myPostOrderBuilder.getNodeToPostOrder().get((int)edge.getFromIndex());
                    if (DominatorTreeBuilder.this.myDominators.get(retainerPostIndex) != DominatorTreeBuilder.this.myNodesCnt) {
                        if (newDominatorIndex[0] == DominatorTreeBuilder.this.myNodesCnt) {
                            newDominatorIndex[0] = retainerPostIndex;
                        } else {
                            while (retainerPostIndex != newDominatorIndex[0]) {
                                while (retainerPostIndex < newDominatorIndex[0]) {
                                    retainerPostIndex = DominatorTreeBuilder.this.myDominators.get(retainerPostIndex);
                                }
                                while (newDominatorIndex[0] < retainerPostIndex) {
                                    newDominatorIndex[0] = DominatorTreeBuilder.this.myDominators.get(newDominatorIndex[0]);
                                }
                            }
                            if (newDominatorIndex[0] == DominatorTreeBuilder.this.myRootPostOrderIndex) {
                                this.breakFlag = true;
                                return false;
                            }
                        }
                    }
                    return true;
                }
            });
            if (orphanNode[0]) {
                newDominatorIndex[0] = this.myRootPostOrderIndex;
            }
            if (newDominatorIndex[0] == this.myNodesCnt || this.myDominators.get(postOrderIndex) == newDominatorIndex[0]) continue;
            this.myDominators.set(postOrderIndex, newDominatorIndex[0]);
            for (V8HeapEdge edge : this.myReader.getChildrenByNodeId(Long.valueOf(nodeIdx))) {
                this.myAffected.set(this.myPostOrderBuilder.getNodeToPostOrder().get((int)edge.getToIndex()), 1);
            }
            changed = true;
        }
        return changed;
    }
}

