/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.nodejs.run.profile.heap.calculation.HeapSnapshotListener;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapHeader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public class HeapSnapshotReader
implements Closeable {
    @NotNull
    private final File myFile;
    private JsonReader myReader;
    private long myNodesCnt;
    private long myEdgesCnt;
    private long myStringsCnt;
    private boolean myHaveTraceData;

    public HeapSnapshotReader(@NotNull File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/run/profile/heap/calculation/HeapSnapshotReader", "<init>"));
        }
        this.myHaveTraceData = false;
        this.myFile = file;
        FileInputStream fileReader = new FileInputStream(this.myFile);
        InputStreamReader ir = new InputStreamReader((InputStream)fileReader, CharsetToolkit.UTF8_CHARSET);
        this.myReader = new JsonReader((Reader)ir);
        this.myStringsCnt = 0L;
    }

    public V8HeapHeader readHeader() throws IOException {
        this.myReader.beginObject();
        HeapSnapshotReader.assertName(this.myReader, "snapshot");
        this.myReader.beginObject();
        String name = this.myFile.getName();
        long traceFunctionsCnt = 0L;
        while (JsonToken.NAME.equals((Object)this.myReader.peek())) {
            String readName = this.myReader.nextName();
            if ("title".equals(readName)) {
                name = readName;
                this.myReader.skipValue();
                continue;
            }
            if ("node_count".equals(readName)) {
                this.myNodesCnt = this.myReader.nextLong();
                continue;
            }
            if ("edge_count".equals(readName)) {
                this.myEdgesCnt = this.myReader.nextLong();
                continue;
            }
            if ("trace_function_count".equals(readName)) {
                traceFunctionsCnt = this.myReader.nextLong();
                this.myHaveTraceData = true;
                continue;
            }
            this.myReader.skipValue();
        }
        this.myReader.endObject();
        return new V8HeapHeader(name, this.myNodesCnt, this.myEdgesCnt, traceFunctionsCnt);
    }

    @Override
    public void close() throws IOException {
        this.myReader.close();
    }

    public void readWithReader(@NotNull HeapSnapshotListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/run/profile/heap/calculation/HeapSnapshotReader", "readWithReader"));
        }
        while (JsonToken.NAME.equals((Object)this.myReader.peek())) {
            String name = this.myReader.nextName();
            if ("nodes".equals(name)) {
                this.readNodes(this.myReader, listener);
                listener.allNodesRead();
                continue;
            }
            if ("edges".equals(name)) {
                this.readEdges(this.myReader, listener);
                listener.allEdgesRead();
                continue;
            }
            if ("strings".equals(name)) {
                this.myReader.beginArray();
                ++this.myStringsCnt;
                listener.stringsCount(this.myStringsCnt);
                while (this.myReader.hasNext()) {
                    String string = this.myReader.nextString();
                    listener.accept(string);
                }
                this.myReader.endArray();
                continue;
            }
            this.myReader.skipValue();
        }
        this.myReader.endObject();
    }

    private void readEdges(JsonReader reader, HeapSnapshotListener listener) throws IOException {
        reader.beginArray();
        int i = 0;
        while ((long)i < this.myEdgesCnt) {
            long toIndex;
            long nameId;
            int typeCode = reader.nextInt();
            V8HeapEdge edge = V8HeapEdge.createFromJson(typeCode, nameId = reader.nextLong(), toIndex = reader.nextLong(), i);
            if (edge.hasStringName()) {
                this.myStringsCnt = Math.max(this.myStringsCnt, nameId);
            }
            listener.accept(edge);
            ++i;
        }
        reader.endArray();
    }

    private void readNodes(JsonReader reader, HeapSnapshotListener listener) throws IOException {
        reader.beginArray();
        int i = 0;
        while ((long)i < this.myNodesCnt) {
            int type = reader.nextInt();
            long nameId = reader.nextLong();
            long snapshotId = reader.nextLong();
            long size = reader.nextLong();
            long childrenCount = reader.nextLong();
            long traceId = this.myHaveTraceData ? reader.nextLong() : -1L;
            this.myStringsCnt = Math.max(this.myStringsCnt, nameId);
            listener.accept(V8HeapEntry.createFromJson(type, nameId, snapshotId, childrenCount, size, traceId, i));
            ++i;
        }
        reader.endArray();
    }

    private static void assertName(@NotNull JsonReader reader, @NotNull String name) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/calculation/HeapSnapshotReader", "assertName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/run/profile/heap/calculation/HeapSnapshotReader", "assertName"));
        }
        String readName = reader.nextName();
        if (!name.equals(readName)) {
            throw new JsonParseException("Wrong format");
        }
    }
}

