/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.Convertor;
import com.jetbrains.nodejs.run.profile.heap.calculation.PortionProcessor;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.SizeOffset;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProcessInPortions<In, Out>
implements Closeable {
    private static final int PORTION_SIZE = 10000;
    @NotNull
    private final RawSerializer<Out> myOutSerializer;
    private long myPortionSize;
    private long myNodesCnt;
    @NotNull
    private final RawSerializer<In> mySerializer;
    @NotNull
    private final Convertor<In, Long> myIndexConvertor;
    @NotNull
    private final Convertor<In, Out> myInOutConvertor;
    private final File myNumLinksFile;
    private final File myLinksFile;
    private final SequentialRawWriter<SizeOffset> myNumLinksWriter;
    private final SequentialRawWriter<Out> myReverseLinksWriter;
    private long myOffset;
    private PairConsumer<Long, Set<Out>> myFilter;

    /*
     * WARNING - void declaration
     */
    public ProcessInPortions(long nodesCnt, long portionSize, @NotNull RawSerializer<In> inSerializer, @NotNull RawSerializer<Out> outSerializer, @NotNull Convertor<In, Long> indexConvertor, @NotNull Convertor<In, Out> inOutConvertor, File file, File file2) throws IOException {
        void linksFile;
        void numLinksFile;
        if (inSerializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inSerializer", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "<init>"));
        }
        if (outSerializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outSerializer", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "<init>"));
        }
        if (indexConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexConvertor", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "<init>"));
        }
        if (inOutConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inOutConvertor", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "<init>"));
        }
        this.myOutSerializer = outSerializer;
        this.myNodesCnt = nodesCnt <= 0L ? 10000L : nodesCnt;
        this.mySerializer = inSerializer;
        this.myIndexConvertor = indexConvertor;
        this.myInOutConvertor = inOutConvertor;
        this.myNumLinksFile = numLinksFile;
        this.myLinksFile = linksFile;
        this.myNumLinksWriter = new SequentialRawWriter<SizeOffset>(this.myNumLinksFile, SizeOffset.MySerializer.getInstance());
        this.myReverseLinksWriter = new SequentialRawWriter<Out>(this.myLinksFile, outSerializer);
        this.myPortionSize = portionSize <= 0L ? 10000L : portionSize;
        this.myOffset = 0L;
    }

    public void setFilter(@NotNull PairConsumer<Long, Set<Out>> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "setFilter"));
        }
        this.myFilter = filter;
    }

    public void correctSize(long value) {
        this.myNodesCnt = value;
    }

    public void continueCalculation(@NotNull File inFile, long size) throws IOException {
        long from;
        if (inFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inFile", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "continueCalculation"));
        }
        int steps = (int)(this.myNodesCnt / this.myPortionSize);
        for (int i = 1; i <= steps && (from = (long)i * this.myPortionSize) < this.myNodesCnt; ++i) {
            long to = from + this.myPortionSize - 1L;
            to = Math.min(to, this.myNodesCnt - 1L);
            new SequentialRawReader<In>(inFile, this.mySerializer, size).iterate(this.getStageCalculator(from, to));
        }
    }

    public void continueCalculation(@NotNull ThrowableConsumer<CloseableThrowableConsumer<In, IOException>, IOException> consumer) throws IOException {
        long from;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "continueCalculation"));
        }
        int steps = (int)(this.myNodesCnt / this.myPortionSize);
        for (int i = 1; i <= steps && (from = (long)i * this.myPortionSize) < this.myNodesCnt; ++i) {
            long to = from + this.myPortionSize - 1L;
            to = Math.min(to, this.myNodesCnt - 1L);
            consumer.consume(this.getStageCalculator(from, to));
        }
    }

    public CloseableThrowableConsumer<In, IOException> getFirstStageCalculator() {
        return this.getStageCalculator(0L, Math.min(this.myPortionSize - 1L, this.myNodesCnt - 1L));
    }

    @NotNull
    public CloseableThrowableConsumer<In, IOException> getStageCalculator(long from, long to) {
        final PortionProcessor<In, Out> calculator = new PortionProcessor<In, Out>(from, to, this.myInOutConvertor);
        if (this.myFilter != null) {
            calculator.setFilter(this.myFilter);
        }
        CloseableThrowableConsumer closeableThrowableConsumer = new CloseableThrowableConsumer<In, IOException>(){

            public void consume(In in) throws IOException {
                calculator.accept((Long)ProcessInPortions.this.myIndexConvertor.convert(in), in);
            }

            @Override
            public void close() throws IOException {
                calculator.flush((ThrowableConsumer<Long, IOException>)((ThrowableConsumer)size -> {
                    ProcessInPortions.this.myNumLinksWriter.write(new SizeOffset(size.intValue(), ProcessInPortions.this.myOffset));
                    ProcessInPortions.this.myOffset = ProcessInPortions.this.myOffset + size;
                }), out -> ProcessInPortions.this.myReverseLinksWriter.write(out));
            }
        };
        if (closeableThrowableConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/calculation/ProcessInPortions", "getStageCalculator"));
        }
        return closeableThrowableConsumer;
    }

    @Override
    public void close() throws IOException {
        this.myNumLinksWriter.close();
        this.myReverseLinksWriter.close();
    }

    public LinksReaderFactory<Out> getLinksReaderFactory() throws FileNotFoundException {
        return new LinksReaderFactory<Out>(this.myOutSerializer, this.myNumLinksFile, this.myLinksFile);
    }

    public File getNumLinksFile() {
        return this.myNumLinksFile;
    }

    public File getLinksFile() {
        return this.myLinksFile;
    }
}

