/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.V8IndexCatalogManager;
import com.jetbrains.nodejs.run.profile.V8IndexManager;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapInMemoryIndexes;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8StringIndex;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapHeader;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8HeapIndexManager
extends V8IndexManager<Category> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager");
    public static final String IDEA_JAVASCRIPT_PROFILING_V8_HEAP_MAX_FILE_MB = "idea.javascript.profiling.v8.heap.max.file.mb";
    public static final Integer MAX_FILE_SIZE = Integer.getInteger("idea.javascript.profiling.v8.heap.max.file.mb", 100) * 0x100000;
    private final boolean myShowHidden;

    public V8HeapIndexManager(@NotNull File snapshotFile, boolean showHidden) throws IOException {
        if (snapshotFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snapshotFile", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "<init>"));
        }
        super(snapshotFile, (Enum[])Category.values());
        this.myShowHidden = showHidden;
    }

    @NotNull
    public static File getSystemDir() {
        File file = new File(PathManager.getSystemPath(), ApplicationManager.getApplication().isUnitTestMode() ? "v8test" : "v8");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "getSystemDir"));
        }
        return file;
    }

    @Override
    protected byte[] createDigest(@NotNull File snapshotFile) throws IOException {
        if (snapshotFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snapshotFile", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "createDigest"));
        }
        return V8HeapIndexManager.snapshotDigest(snapshotFile, this.myShowHidden);
    }

    @Override
    protected Category getDescriptionCategory() {
        return Category.description;
    }

    @Nullable
    public V8CachingReader initReader(@NotNull CompositeCloseable resources, @Nullable Consumer<String> errorNotificator) throws IOException, ClassNotFoundException {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "initReader"));
        }
        List<File> files = this.myIndexFiles.getFiles(Category.strings);
        V8StringIndex stringIndex = resources.register(new V8StringIndex(files.toArray(new File[files.size()])));
        LinksReaderFactory<LinkedByNameId> stringsReverseIndexReaderFactory = new LinksReaderFactory<LinkedByNameId>(LinkedByNameId.Serializer.getInstance(), this.myIndexFiles.getOneFile(Category.stringsNumLinks), this.myIndexFiles.getOneFile(Category.stringsLinks));
        LinksReaderFactory<V8HeapEdge> reverseIndexReaderFactory = new LinksReaderFactory<V8HeapEdge>(V8HeapEdge.MyRawSerializer.getInstance(), this.myIndexFiles.getOneFile(Category.reverseNumLinks), this.myIndexFiles.getOneFile(Category.reverseLinks));
        V8HeapHeader header = new V8HeapHeader();
        V8ImportantStringsHolder holder = new V8ImportantStringsHolder();
        File headerFile = this.myIndexFiles.getOneFile(Category.header);
        this.readHeader(headerFile, header, holder);
        V8CachingReader reader = new V8CachingReader(this.mySnapshotFile, this.myDigest, resources, header, errorNotificator, stringIndex, this.myIndexFiles.getOneFile(Category.nodeIdx), this.myIndexFiles.getOneFile(Category.edgeIdx), stringsReverseIndexReaderFactory, reverseIndexReaderFactory, holder);
        File inMemory = this.myIndexFiles.getOneFile(Category.inMemoryIndexes);
        V8HeapInMemoryIndexes inMemoryIndexes = new V8HeapInMemoryIndexes();
        V8HeapIndexManager.readExternalizableFromFile(inMemoryIndexes, inMemory);
        LinksReaderFactory<Long> aggregatesReaderFactory = new LinksReaderFactory<Long>(new LongRawSerializer(), this.myIndexFiles.getOneFile(Category.aggregateNum), this.myIndexFiles.getOneFile(Category.aggregateLinks));
        reader.setInMemoryIndexes(inMemoryIndexes);
        reader.setAggregatesLinksReaderFactory(aggregatesReaderFactory);
        if (!this.myShowHidden) {
            reader.resetDoNotShowHidden();
        }
        return reader;
    }

    public void recordReader(@NotNull V8CachingReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "recordReader"));
        }
        if (this.myDoNotSerialize) {
            return;
        }
        this.writeHeader(reader, this.myIndexFiles.generate(Category.header, ".header"));
        this.writeExternalizableToFile(reader.getInMemoryIndexes(), this.myIndexFiles.generate(Category.inMemoryIndexes, ".inMemory"));
        File description = this.categoryFile(Category.description);
        V8IndexCatalogManager.writeDigests(this.myIndexFiles.getFilesMap(), description);
    }

    private void writeExternalizableToFile(@NotNull Externalizable externalizable, @NotNull File file) throws IOException {
        if (externalizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizable", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "writeExternalizableToFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "writeExternalizableToFile"));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(out);
        externalizable.writeExternal(stream);
        stream.flush();
        FileUtil.writeToFile((File)file, (byte[])out.toByteArray());
    }

    private static void readExternalizableFromFile(@NotNull Externalizable externalizable, @NotNull File file) throws IOException, ClassNotFoundException {
        if (externalizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizable", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "readExternalizableFromFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "readExternalizableFromFile"));
        }
        V8HeapIndexManager.checkFileSize(file.length());
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        externalizable.readExternal(ois);
    }

    private static void checkFileSize(long length) throws IOException {
        if (length > (long)MAX_FILE_SIZE.intValue()) {
            throw new IOException("Can not load V8 Heap indexes file, file is too big.\nPlease specify a greater value in megabytes for property 'idea.javascript.profiling.v8.heap.max.file.mb' in idea.properties file.");
        }
    }

    private void writeHeader(@NotNull V8CachingReader reader, @NotNull File file) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "writeHeader"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "writeHeader"));
        }
        V8HeapHeader header = reader.getHeader();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(out);
        header.writeExternal(stream);
        V8ImportantStringsHolder holder = reader.getImportantStringsHolder();
        holder.writeExternal(stream);
        stream.flush();
        FileUtil.writeToFile((File)file, (byte[])out.toByteArray());
    }

    private void readHeader(@NotNull File file, @NotNull V8HeapHeader header, @NotNull V8ImportantStringsHolder holder) throws IOException, ClassNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "readHeader"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "readHeader"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "readHeader"));
        }
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        header.readExternal(ois);
        holder.readExternal(ois);
    }

    public static byte[] snapshotDigest(@NotNull File snapshotFile, boolean showHidden) throws IOException {
        if (snapshotFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snapshotFile", "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapIndexManager", "snapshotDigest"));
        }
        return V8IndexCatalogManager.digestFile(snapshotFile, new byte[][]{(showHidden ? "hidden" : "user").getBytes(CharsetToolkit.UTF8_CHARSET)});
    }

    public static enum Category {
        description,
        nodeIdx,
        edgeIdx,
        strings,
        stringsNumLinks,
        stringsLinks,
        reverseNumLinks,
        reverseLinks,
        aggregateNum,
        aggregateLinks,
        header,
        inMemoryIndexes;

    }
}

