/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregateDifferenceEmphasizerI;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.DiffCellRenderer;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8DiffCachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.SizeRenderer;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiggestObjectsDiffTableModel
implements TreeTableModelWithCustomRenderer {
    private final Object myRoot;
    private final ColumnInfo[] myColumns;
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8DiffCachingReader myReader;
    private DiffCellRenderer myRenderer;

    public BiggestObjectsDiffTableModel(@NotNull Project project, @NotNull V8DiffCachingReader reader) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/BiggestObjectsDiffTableModel", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/BiggestObjectsDiffTableModel", "<init>"));
        }
        this.myRoot = new Object();
        this.myProject = project;
        this.myReader = reader;
        this.myColumns = new ColumnInfo[5];
        this.fillColumns();
    }

    private void fillColumns() {
        this.myRenderer = new DiffCellRenderer(this.myProject, this.myReader.getBaseReader(), this.myReader.getChangedReader(), AggregateDifferenceEmphasizerI.EMPTY);
        final RightAlignedRenderer rightAlignedRenderer = new RightAlignedRenderer();
        this.myColumns[0] = new ColumnInfo<Object, Object>("Object"){

            @Nullable
            public Object valueOf(Object o) {
                return o;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)((Object)BiggestObjectsDiffTableModel.this.myRenderer));
                }
                return super.getCustomizedRenderer(o, renderer);
            }
        };
        this.myColumns[1] = new ColumnInfo<Object, Object>("Size Diff"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof BeforeAfter) {
                    BeforeAfter beforeAfter = (BeforeAfter)o;
                    if (beforeAfter.getBefore() == null) {
                        return "+" + SizeRenderer.formatSize(((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getSize());
                    }
                    if (beforeAfter.getAfter() == null) {
                        return "-" + SizeRenderer.formatSize(((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getSize());
                    }
                    long diff = ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getSize() - ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getSize();
                    return BiggestObjectsDiffTableModel.this.sign(diff) + SizeRenderer.formatSize(Math.abs(diff));
                }
                return null;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return rightAlignedRenderer;
            }
        };
        this.myColumns[2] = new ColumnInfo<Object, Object>("Size"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof BeforeAfter) {
                    long beforeSize;
                    BeforeAfter beforeAfter = (BeforeAfter)o;
                    long afterSize = beforeAfter.getAfter() == null ? 0L : ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getSize();
                    long l = beforeSize = beforeAfter.getBefore() == null ? 0L : ((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getSize();
                    if (beforeAfter.getBefore() == null) {
                        return "+" + SizeRenderer.formatSize(afterSize);
                    }
                    if (beforeAfter.getAfter() == null) {
                        return "-" + SizeRenderer.formatSize(beforeSize);
                    }
                    return beforeSize == afterSize ? SizeRenderer.formatSize(beforeSize) : SizeRenderer.formatSize(beforeSize) + "->" + SizeRenderer.formatSize(afterSize);
                }
                return null;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return rightAlignedRenderer;
            }
        };
        this.myColumns[3] = new ColumnInfo<Object, Object>("Retained Size Diff"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof BeforeAfter) {
                    BeforeAfter beforeAfter = (BeforeAfter)o;
                    if (beforeAfter.getBefore() == null) {
                        return "+" + SizeRenderer.formatSize(BiggestObjectsDiffTableModel.this.myReader.getChangedReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getId()));
                    }
                    if (beforeAfter.getAfter() == null) {
                        return "-" + SizeRenderer.formatSize(BiggestObjectsDiffTableModel.this.myReader.getBaseReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getId()));
                    }
                    long diff = BiggestObjectsDiffTableModel.this.myReader.getChangedReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getId()) - BiggestObjectsDiffTableModel.this.myReader.getBaseReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getId());
                    return BiggestObjectsDiffTableModel.this.sign(diff) + SizeRenderer.formatSize(Math.abs(diff));
                }
                return null;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return rightAlignedRenderer;
            }
        };
        this.myColumns[4] = new ColumnInfo<Object, Object>("Retained Size"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof BeforeAfter) {
                    long beforeSize;
                    BeforeAfter beforeAfter = (BeforeAfter)o;
                    long afterSize = beforeAfter.getAfter() == null ? 0L : BiggestObjectsDiffTableModel.this.myReader.getChangedReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry().getId());
                    long l = beforeSize = beforeAfter.getBefore() == null ? 0L : BiggestObjectsDiffTableModel.this.myReader.getBaseReader().getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry().getId());
                    if (beforeAfter.getBefore() == null) {
                        return "+" + SizeRenderer.formatSize(afterSize);
                    }
                    if (beforeAfter.getAfter() == null) {
                        return "-" + SizeRenderer.formatSize(beforeSize);
                    }
                    return beforeSize == afterSize ? SizeRenderer.formatSize(beforeSize) : SizeRenderer.formatSize(beforeSize) + "->" + SizeRenderer.formatSize(afterSize);
                }
                return null;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return rightAlignedRenderer;
            }
        };
    }

    private String sign(long value) {
        return value == 0L ? " " : (value < 0L ? "-" : "+");
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.myRoot) {
            return this.myReader.getBiggestObjectsDiff().get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent == this.myRoot) {
            return this.myReader.getBiggestObjectsDiff().size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node != this.myRoot;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.myRoot) {
            List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> list = this.myReader.getBiggestObjectsDiff();
            for (int i = 0; i < list.size(); ++i) {
                BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry> beforeAfter = list.get(i);
                if (!beforeAfter.equals(child)) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }
}

