/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregateDifferenceEmphasizerI;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregatesViewDiff;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import java.util.ArrayList;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class DiffCellRenderer
extends DirectTreeTableRenderer {
    @NotNull
    private final V8CachingReader myBaseReader;
    @NotNull
    private final V8CachingReader myChangedReader;
    @NotNull
    private final AggregateDifferenceEmphasizerI myEmphasizer;
    private SimpleTextAttributes mySelectedBold;

    public DiffCellRenderer(@NotNull Project project, @NotNull V8CachingReader baseReader, @NotNull V8CachingReader changedReader, @NotNull AggregateDifferenceEmphasizerI emphasizer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/DiffCellRenderer", "<init>"));
        }
        if (baseReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseReader", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/DiffCellRenderer", "<init>"));
        }
        if (changedReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedReader", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/DiffCellRenderer", "<init>"));
        }
        if (emphasizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emphasizer", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/DiffCellRenderer", "<init>"));
        }
        super(project, baseReader);
        this.myBaseReader = baseReader;
        this.myChangedReader = changedReader;
        this.myEmphasizer = emphasizer;
        this.mySelectedBold = SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES.derive(1, null, null, null);
    }

    @Override
    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/nodejs/run/profile/heap/calculation/diff/DiffCellRenderer", "customizeCellRenderer"));
        }
        this.setIcon(null);
        if (value instanceof AggregatesViewDiff.AggregateDifference) {
            String presentation;
            this.setBackground(null);
            int width = this.getWidth(tree, row);
            AggregatesViewDiff.AggregateDifference difference = (AggregatesViewDiff.AggregateDifference)value;
            String string = presentation = difference.getChanged() == null ? difference.getBase().getPresentation(this.myBaseReader) : difference.getChanged().getPresentation(this.myChangedReader);
            SimpleTextAttributes att = this.myEmphasizer.emphasize(difference) ? (selected ? this.mySelectedBold : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Aggregate aggregate = difference.getChanged() == null ? difference.getBase() : difference.getChanged();
            ArrayList<DirectTreeTableRenderer.PartRenderer> list = new ArrayList<DirectTreeTableRenderer.PartRenderer>();
            this.appendAggregateNameRenderer(aggregate, presentation, list, att);
            boolean lineHasFocus = ((TreeTableTree)tree).getTreeTable().hasFocus();
            boolean selectedForeground = selected && (lineHasFocus || UIUtil.isUnderDarcula());
            this.adaptiveRendering(list, width, selectedForeground);
        } else if (value instanceof BeforeAfter) {
            BeforeAfter beforeAfter = (BeforeAfter)value;
            if (beforeAfter.getAfter() == null) {
                this.setIcon(AllIcons.General.Remove);
                this.myReader = this.myBaseReader;
                super.customizeCellRenderer(tree, beforeAfter.getBefore(), selected, expanded, leaf, row, hasFocus);
            } else {
                if (beforeAfter.getBefore() == null) {
                    this.setIcon(AllIcons.General.Add);
                }
                this.myReader = this.myChangedReader;
                super.customizeCellRenderer(tree, beforeAfter.getAfter(), selected, expanded, leaf, row, hasFocus);
            }
        } else {
            super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

