/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class IntArraySerializer
implements RawSerializer<int[]> {
    private final int mySize;

    public IntArraySerializer(int size) {
        this.mySize = size;
    }

    @Override
    public long getRecordSize() {
        return 4 * this.mySize;
    }

    @Override
    public void write(@NotNull DataOutput os, @NotNull int[] ints) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/jetbrains/nodejs/run/profile/heap/io/IntArraySerializer", "write"));
        }
        if (ints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ints", "com/jetbrains/nodejs/run/profile/heap/io/IntArraySerializer", "write"));
        }
        for (int anInteger : ints) {
            RawSerializer.Helper.serializeInt(anInteger, os);
        }
    }

    @Override
    public int[] read(@NotNull DataInput is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "com/jetbrains/nodejs/run/profile/heap/io/IntArraySerializer", "read"));
        }
        int[] array = new int[this.mySize];
        for (int i = 0; i < this.mySize; ++i) {
            array[i] = RawSerializer.Helper.deserializeInt(is);
        }
        return array;
    }
}

