/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class LongArraySerializer
implements RawSerializer<long[]> {
    private final int mySize;

    public LongArraySerializer(int size) {
        this.mySize = size;
    }

    @Override
    public long getRecordSize() {
        return 8 * this.mySize;
    }

    @Override
    public void write(@NotNull DataOutput os, @NotNull long[] longs) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/jetbrains/nodejs/run/profile/heap/io/LongArraySerializer", "write"));
        }
        if (longs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "longs", "com/jetbrains/nodejs/run/profile/heap/io/LongArraySerializer", "write"));
        }
        for (long aLong : longs) {
            RawSerializer.Helper.serializeLong(aLong, os);
        }
    }

    @Override
    public long[] read(@NotNull DataInput is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "com/jetbrains/nodejs/run/profile/heap/io/LongArraySerializer", "read"));
        }
        long[] array = new long[this.mySize];
        for (int i = 0; i < this.mySize; ++i) {
            array[i] = RawSerializer.Helper.deserializeLong(is);
        }
        return array;
    }
}

