/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.util.ArrayUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTableWithRetainers;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.AggregatesTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapAggregatesView
implements ProfilingView<V8HeapTreeTable> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8CachingReader myReader;
    @NotNull
    private final V8MainTreeNavigator myContainmentNavigator;
    private final V8MainTableWithRetainers<AggregatesTableModel> myMainTableWithRetainers;

    public HeapAggregatesView(@NotNull Project project, @NotNull V8CachingReader reader, @NotNull V8MainTreeNavigator containmentNavigator, @NotNull Disposable disposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/heap/view/components/HeapAggregatesView", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/view/components/HeapAggregatesView", "<init>"));
        }
        if (containmentNavigator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containmentNavigator", "com/jetbrains/nodejs/run/profile/heap/view/components/HeapAggregatesView", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/nodejs/run/profile/heap/view/components/HeapAggregatesView", "<init>"));
        }
        this.myContainmentNavigator = containmentNavigator;
        this.myReader = reader;
        this.myProject = project;
        this.myMainTableWithRetainers = new V8MainTableWithRetainers<AggregatesTableModel>(this.myProject, new AggregatesTableModel(this.myProject, this.myReader), this.myReader, this.myReader.getResourses(), disposable);
        this.myMainTableWithRetainers.setUseTreeSelectionForRetainers(false);
        this.myMainTableWithRetainers.setMainTreeNavigator(this.myContainmentNavigator);
    }

    @Override
    public JComponent getMainComponent() {
        DataProviderPanel panel = DataProviderPanel.wrap((JComponent)this.myMainTableWithRetainers.getMainSplitter());
        panel.register(V8NavigateToMainTreeAction.MAIN_TREE_NAVIGATOR.getName(), (Getter<Object>)((Getter)() -> this.myContainmentNavigator));
        panel.register(V8NavigateToMainTreeAction.TREE_PATH.getName(), (Getter<Object>)((Getter)() -> {
            TreePath path;
            if (this.myMainTableWithRetainers.getTable().isFocusOwner() && (path = this.myMainTableWithRetainers.getTable().getTree().getSelectionPath()) != null && path.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry && this.myMainTableWithRetainers.getRetainersTreeModel() != null && this.myMainTableWithRetainers.getRetainersTreeModel().getMain() != null && this.myMainTableWithRetainers.getRetainersTreeModel().getMain().equals(((V8HeapContainmentTreeTableModel.NamedEntry)path.getLastPathComponent()).getEntry())) {
                List<V8HeapContainmentTreeTableModel.NamedEntry> list = this.myMainTableWithRetainers.getRetainersTreeModel().getPathForSelectionInMainTree("Chain from root:");
                return list == null ? null : new TreePath(ArrayUtil.toObjectArray(list));
            }
            return null;
        }));
        panel.register(MarkUnmarkAction.SELECTED_NODE.getName(), (Getter<Object>)((Getter)() -> {
            TreePath value = this.myMainTableWithRetainers.getTable().getTree().getSelectionPath();
            if (value != null && value.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                return ((V8HeapContainmentTreeTableModel.NamedEntry)value.getLastPathComponent()).getEntry();
            }
            return null;
        }));
        panel.register(MarkUnmarkAction.REVALIDATION.getName(), new Getter<Object>(){
            private final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    HeapAggregatesView.this.myMainTableWithRetainers.getTable().revalidate();
                    HeapAggregatesView.this.myMainTableWithRetainers.getTable().repaint();
                }
            };

            public Object get() {
                return this.runnable;
            }
        });
        return panel;
    }

    @Override
    public String getName() {
        return "Summary";
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new MarkUnmarkAction(this.myProject, this.myReader));
        group.add((AnAction)new V8NavigateToMainTreeAction());
        group.add((AnAction)new GoToSourceAction(this.myReader, this.myMainTableWithRetainers.getTable()));
        V8Utils.installHeapPopupMenu(this.myProject, this.myMainTableWithRetainers.getTable(), this.myReader, this.myContainmentNavigator);
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8HeapTreeTable getTreeTable() {
        return this.myMainTableWithRetainers.getTable();
    }

    @Override
    public void defaultExpand() {
    }
}

