/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.util.CloseableProcessor;
import com.jetbrains.nodejs.util.CloseableThrowableProcessor;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8DistancesInspection
extends Task.Backgroundable {
    private static final String[] FILTER_NAMES = new String[]{"__proto__", "prototype", "constructor", "v8", "source", "exports", "super_", "type"};
    @NotNull
    private final V8CachingReader myReader;
    private final int MIN_DISTANCE_VARIANCE = 5;
    private final int MAX_DISTANCE_VARIANCE = 50;
    private final int MAX_NAMES = 50;
    private final Map<Long, TypeData> myByTypesData;
    private TreeMap<Long, TypeData> mySortedByTypes;
    private IOException myException;
    private HashMap<Long, Set<Long>> myByNamesMap;
    private ArrayList<List<Long>> mySortedByNames;

    public V8DistancesInspection(@Nullable Project project, @NotNull V8CachingReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection", "<init>"));
        }
        super(project, "Checking Snapshot Distances", false);
        this.MIN_DISTANCE_VARIANCE = 5;
        this.MAX_DISTANCE_VARIANCE = 50;
        this.MAX_NAMES = 50;
        this.myReader = reader;
        this.myByTypesData = new HashMap();
        this.myByNamesMap = new HashMap();
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection", "run"));
        }
        try {
            this.doByTypes(indicator);
            this.doByNames(indicator);
        }
        catch (IOException e) {
            this.myException = e;
        }
    }

    private void doByNames(ProgressIndicator indicator) throws IOException {
        indicator.setText("Looking for filtered names ids...");
        Set<Long> filterIds = this.fillFilteredStrings();
        indicator.setText("Iterating reverse string index...");
        this.myReader.getStringReverseIndexReaderFactory().create(true).iterate((Processor<List<LinkedByNameId>>)((Processor)ids -> {
            if (ids.size() >= 5) {
                V8HeapEdge edge;
                HashSet<Long> links = new HashSet<Long>();
                for (LinkedByNameId id : ids) {
                    if (id.isNode()) continue;
                    links.add(id.getId());
                }
                if (links.size() >= 5 && !filterIds.contains((edge = this.myReader.getEdge((Long)links.iterator().next())).getNameId())) {
                    this.myByNamesMap.put((Object)edge.getNameId(), links);
                }
            }
            return true;
        }));
        indicator.setText("Filtering by name groups (removing hidden and small)...");
        Iterator iterator = this.myByNamesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashSet<Integer> set = new HashSet<Integer>();
            Iterator edgeIterator = ((Set)entry.getValue()).iterator();
            boolean skipFinishChecks = false;
            while (edgeIterator.hasNext()) {
                Long edgeId = (Long)edgeIterator.next();
                V8HeapEdge edge = this.myReader.getEdge(edgeId);
                if (V8HeapGraphEdgeType.kElement.equals((Object)edge.getType())) {
                    iterator.remove();
                    skipFinishChecks = true;
                    break;
                }
                if (V8HeapGraphEdgeType.isInternalKind(edge.getType()) || V8DistancesInspection.nodeIsHidden(this.myReader.getNode(edge.getToIndex()))) {
                    edgeIterator.remove();
                    continue;
                }
                set.add(this.myReader.getDistance((int)edge.getToIndex()));
            }
            if (skipFinishChecks || !((Set)entry.getValue()).isEmpty() && set.size() >= 5) continue;
            iterator.remove();
        }
        this.mySortedByNames = new ArrayList();
        for (Map.Entry entry : this.myByNamesMap.entrySet()) {
            this.mySortedByNames.add(new ArrayList((Collection)entry.getValue()));
        }
        Collections.sort(this.mySortedByNames, (o1, o2) -> new Integer(o2.size()).compareTo(o1.size()));
        this.myByNamesMap.clear();
    }

    @NotNull
    private Set<Long> fillFilteredStrings() throws IOException {
        final HashSet<String> filterStrings = new HashSet<String>(Arrays.asList(FILTER_NAMES));
        final HashSet<Long> filterIds = new HashSet<Long>();
        this.myReader.getStringIndex().iterate(new CloseableProcessor<Pair<Long, String>, IOException>(){

            @Override
            public void exceptionThrown(@NotNull IOException e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection$1", "exceptionThrown"));
                }
                V8DistancesInspection.this.myException = e;
            }

            @Override
            public void close() throws IOException {
            }

            public boolean process(Pair<Long, String> pair) {
                if (filterStrings.remove(pair.getSecond())) {
                    filterIds.add(pair.getFirst());
                }
                return !filterStrings.isEmpty();
            }
        });
        HashSet<Long> hashSet = filterIds;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection", "fillFilteredStrings"));
        }
        return hashSet;
    }

    private static boolean nodeIsHidden(V8HeapEntry entry) {
        return V8HeapNodeType.kHidden.equals((Object)entry.getType()) || V8HeapNodeType.kSynthetic.equals((Object)entry.getType());
    }

    public ArrayList<List<Long>> getByNamesList() {
        return this.mySortedByNames;
    }

    private void doByTypes(ProgressIndicator indicator) throws IOException {
        indicator.setText("Marking nodes referenced by hidden links only...");
        final TIntHashSet onlyHiddenLinks = new TIntHashSet();
        LinksReader<V8HeapEdge> linksReader = this.myReader.getReverseLinkIndexReaderFactory().create(true);
        linksReader.iterate(new Processor<List<V8HeapEdge>>(){
            int idx = 0;

            public boolean process(List<V8HeapEdge> edges) {
                boolean notHidden = false;
                for (V8HeapEdge edge : edges) {
                    if (V8HeapGraphEdgeType.isInternalKind(edge.getType())) continue;
                    notHidden = true;
                    break;
                }
                if (!notHidden) {
                    onlyHiddenLinks.add(this.idx);
                }
                ++this.idx;
                return true;
            }
        });
        indicator.setText("Grouping nodes by classes...");
        SequentialRawReader<V8HeapEntry> reader = new SequentialRawReader<V8HeapEntry>(this.myReader.getNodeIndexFile(), V8HeapEntry.MyRawSerializer.getInstance(), this.myReader.getNodeCount());
        reader.iterate(new CloseableThrowableProcessor<V8HeapEntry, IOException>(){

            @Override
            public boolean process(V8HeapEntry entry) throws IOException {
                if (onlyHiddenLinks.contains((int)entry.getId()) || V8HeapNodeType.kHidden.equals((Object)entry.getType()) || V8HeapNodeType.kSynthetic.equals((Object)entry.getType()) || V8HeapNodeType.kCode.equals((Object)entry.getType())) {
                    return true;
                }
                long classIndex = entry.getClassIndex();
                TypeData typeData = (TypeData)V8DistancesInspection.this.myByTypesData.get(classIndex);
                if (typeData == null) {
                    typeData = new TypeData();
                    V8DistancesInspection.this.myByTypesData.put(classIndex, typeData);
                }
                typeData.entry(entry);
                return true;
            }

            @Override
            public void close() throws IOException {
            }
        });
        indicator.setText("Filtering by class groups...");
        Iterator<TypeData> iterator = this.myByTypesData.values().iterator();
        while (iterator.hasNext()) {
            TypeData typeData = iterator.next();
            if (typeData.getMap().size() >= 5) continue;
            iterator.remove();
        }
        this.mySortedByTypes = new TreeMap((key1, key2) -> {
            if (this.myByTypesData.isEmpty()) {
                return new Long(this.mySortedByTypes.get(key2).getMaxRetainedSize()).compareTo(this.mySortedByTypes.get(key1).getMaxRetainedSize());
            }
            return new Long(this.myByTypesData.get(key2).getMaxRetainedSize()).compareTo(this.myByTypesData.get(key1).getMaxRetainedSize());
        });
        this.mySortedByTypes.putAll(this.myByTypesData);
        this.myByTypesData.clear();
    }

    public TreeMap<Long, TypeData> getSortedByTypes() {
        return this.mySortedByTypes;
    }

    public IOException getException() {
        return this.myException;
    }

    class TypeData {
        private long myMaxRetainedSize = 0L;
        private final TreeMap<Integer, Pair<V8HeapEntry, V8HeapEdge>> myMap = new TreeMap();
        private boolean mySomethingMissing;

        private void putEntry(@NotNull V8HeapEntry entry, int distance) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection$TypeData", "putEntry"));
            }
            long parentId = V8DistancesInspection.this.myReader.getNodeParent((int)entry.getId());
            V8HeapEntry parent = V8DistancesInspection.this.myReader.getNode(parentId);
            Pair<V8HeapEntry, V8HeapEdge> p = V8DistancesInspection.this.myReader.getChildById(parent, entry.getId());
            if (parent.getSnapshotObjectId() == -1L || ((V8HeapEntry)p.getFirst()).getSnapshotObjectId() == -1L) {
                this.myMap.put(distance, (Pair<V8HeapEntry, V8HeapEdge>)Pair.create((Object)entry, null));
            } else {
                this.myMap.put(distance, p);
            }
        }

        private long add(@NotNull V8HeapEntry entry, int distance) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection$TypeData", "add"));
            }
            long retainedSize = V8DistancesInspection.this.myReader.getRetainedSize((int)entry.getId());
            Pair<V8HeapEntry, V8HeapEdge> before = this.myMap.get(distance);
            if (before != null) {
                if (V8DistancesInspection.this.myReader.getRetainedSize((int)((V8HeapEntry)before.getFirst()).getId()) < retainedSize) {
                    this.putEntry(entry, distance);
                }
            } else {
                this.putEntry(entry, distance);
            }
            this.myMaxRetainedSize = Math.max(this.myMaxRetainedSize, retainedSize);
            return retainedSize;
        }

        public void entry(@NotNull V8HeapEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection$TypeData", "entry"));
            }
            int distance = V8DistancesInspection.this.myReader.getDistance((int)entry.getId());
            if (distance < 0 || distance >= 100000000) {
                return;
            }
            this.add(entry, distance);
            if (this.myMap.size() > 50) {
                Integer key = null;
                long size = Long.MAX_VALUE;
                for (Map.Entry<Integer, Pair<V8HeapEntry, V8HeapEdge>> entryEntry : this.myMap.entrySet()) {
                    long currentSize = V8DistancesInspection.this.myReader.getRetainedSize((int)((V8HeapEntry)entryEntry.getValue().getFirst()).getId());
                    if (currentSize > size) continue;
                    key = entryEntry.getKey();
                    size = currentSize;
                }
                if (key != null) {
                    this.myMap.remove(key);
                    this.mySomethingMissing = true;
                }
            }
        }

        public boolean isSomethingMissing() {
            return this.mySomethingMissing;
        }

        public long getMaxRetainedSize() {
            return this.myMaxRetainedSize;
        }

        public TreeMap<Integer, Pair<V8HeapEntry, V8HeapEdge>> getMap() {
            return this.myMap;
        }
    }
}

