/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.CompareWithSnapshotAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.DistancesInspectionView;
import com.jetbrains.nodejs.run.profile.heap.view.components.SearchDialog;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTableWithRetainers;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8HeapContainmentView
implements ProfilingView<V8HeapTreeTable> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8CachingReader myReader;
    private final String myName;
    private final V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> myTableWithRetainers;
    private DataProviderPanel myPanel;

    public V8HeapContainmentView(@NotNull Project project, @NotNull V8CachingReader reader, String name, @NotNull Disposable disposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapContainmentView", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapContainmentView", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapContainmentView", "<init>"));
        }
        this.myProject = project;
        this.myReader = reader;
        this.myName = name;
        this.myTableWithRetainers = new V8MainTableWithRetainers<V8HeapContainmentTreeTableModel>(project, new V8HeapContainmentTreeTableModel(project, this.myReader), reader, reader.getResourses(), disposable);
        this.createUI();
    }

    @Override
    public JComponent getMainComponent() {
        return this.myPanel;
    }

    private void createUI() {
        this.myPanel = DataProviderPanel.wrap((JComponent)this.myTableWithRetainers.getMainSplitter());
        this.myPanel.register(V8NavigateToMainTreeAction.MAIN_TREE_NAVIGATOR.getName(), (Getter<Object>)((Getter)() -> this.myTableWithRetainers.getMainTreeNavigator()));
        this.myPanel.register(MarkUnmarkAction.SELECTED_LINK.getName(), (Getter<Object>)((Getter)() -> {
            TreePath value = this.myTableWithRetainers.getTable().getTree().getSelectionPath();
            if (value != null && value.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                V8HeapContainmentTreeTableModel.NamedEntry namedEntry = (V8HeapContainmentTreeTableModel.NamedEntry)value.getLastPathComponent();
                return namedEntry.getLinkOffset() / 37L;
            }
            return null;
        }));
        this.myPanel.register(MarkUnmarkAction.SELECTED_NODE.getName(), (Getter<Object>)((Getter)() -> {
            TreePath value = this.myTableWithRetainers.getTable().getTree().getSelectionPath();
            if (value != null && value.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                return ((V8HeapContainmentTreeTableModel.NamedEntry)value.getLastPathComponent()).getEntry();
            }
            return null;
        }));
        this.myPanel.register(MarkUnmarkAction.REVALIDATION.getName(), new Getter<Object>(){
            private final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    V8HeapContainmentView.this.myTableWithRetainers.getTable().revalidate();
                    V8HeapContainmentView.this.myTableWithRetainers.getTable().repaint();
                }
            };

            public Object get() {
                return this.runnable;
            }
        });
        DistancesInspectionView view = new DistancesInspectionView(this.myProject, this.myReader, this.myTableWithRetainers.getMainTreeNavigator());
        DefaultActionGroup group = new DefaultActionGroup();
        view.addActions(group);
        this.myTableWithRetainers.addTabWithoutClose("Distances Inspection", view.getMainComponent(), group, false);
    }

    @Override
    public String getName() {
        return "Containment";
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        V8HeapTreeTable table = this.myTableWithRetainers.getTable();
        group.add((AnAction)new MarkUnmarkAction(this.myProject, this.myReader));
        group.add((AnAction)new MySearchAction(this.myTableWithRetainers, this.myReader));
        group.add((AnAction)new V8NavigateToMainTreeAction());
        group.add((AnAction)new GoToSourceAction(this.myReader, this.myTableWithRetainers.getTable()));
        group.add((AnAction)new CompareWithSnapshotAction(this.myReader, this.myProject, this.myName));
        if (Boolean.getBoolean("idea.nodejs.v8.heap.profiling.show.node.details")) {
            MyNodeDetailsAction nodeDetailsAction = new MyNodeDetailsAction(table, this.myReader);
            group.add((AnAction)nodeDetailsAction);
            nodeDetailsAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(81, 128)), (JComponent)((Object)table));
        }
        V8Utils.installHeapPopupMenu(this.myProject, table, this.myReader, null);
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8HeapTreeTable getTreeTable() {
        return null;
    }

    @Override
    public void defaultExpand() {
    }

    public V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> getTableWithRetainers() {
        return this.myTableWithRetainers;
    }

    private static class MySearchAction
    extends DumbAwareAction {
        private final V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> myTableWithRetainers;
        private final V8CachingReader myReader;

        public MySearchAction(V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> tableWithRetainers, V8CachingReader reader) {
            super("Search String", "Search String", AllIcons.Actions.Search);
            this.myTableWithRetainers = tableWithRetainers;
            this.myReader = reader;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            SearchDialog dialog = new SearchDialog(project, this.myReader, this.myTableWithRetainers);
            dialog.search();
        }
    }

    private static class MyNodeDetailsAction
    extends DumbAwareAction {
        private final TreeTable myTable;
        private final V8CachingReader myReader;

        public MyNodeDetailsAction(TreeTable table, V8CachingReader reader) {
            super("Show Node Details", "Show Node Details", AllIcons.Actions.PreviewDetails);
            this.myTable = table;
            this.myReader = reader;
        }

        public void actionPerformed(AnActionEvent e) {
            Object component;
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            int row = this.myTable.getSelectedRow();
            if (row >= 0 && (component = this.myTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                V8HeapContainmentTreeTableModel.NamedEntry entry = (V8HeapContainmentTreeTableModel.NamedEntry)component;
                StringBuilder sb = new StringBuilder().append("Node name: ").append(this.myReader.getString(entry.getEntry().getNameId()));
                V8HeapEdge edge = this.myReader.getEdge(entry.getLinkOffset() / 37L);
                sb.append(", type: ").append((Object)entry.getEntry().getType()).append("\nEdge name: ").append(entry.getLinkPresentation()).append(", type: ").append((Object)edge.getType()).append("\nis queriable: ").append(this.myReader.getFlags().isQueriable((int)entry.getEntry().getId())).append("\nis page: ").append(this.myReader.getFlags().isPage((int)entry.getEntry().getId()));
                Messages.showInfoMessage((Project)project, (String)sb.toString(), (String)"V8 Heap");
            }
        }
    }
}

