/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.TreeTableWithTreeWidthController;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.plaf.TreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8HeapTreeTable
extends TreeTableWithTreeWidthController {
    private final ColoredTableCellRenderer myDefaultTableRenderer;
    private TreeTableWidthController myWidthController;

    public V8HeapTreeTable(TreeTableModel treeTableModel, CompositeCloseable resources) {
        super(treeTableModel, V8HeapTreeTable.createDisposable(resources));
        this.getTree().putClientProperty((Object)"TreeTableTree", (Object)true);
        this.getTree().setUI((TreeUI)new WideSelectionTreeUI(true, Condition.TRUE));
        this.smallerIndent();
        this.myDefaultTableRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                V8HeapTreeTable.this.getTree().putClientProperty((Object)"TreeTableTree", (Object)table.hasFocus());
                this.setPaintFocusBorder(false);
                if (selected && !table.hasFocus()) {
                    this.setBackground(UIUtil.getTreeUnfocusedSelectionBackground());
                    this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableForeground(), null, null));
                } else {
                    this.append(value.toString());
                }
            }

            protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
                return attributes;
            }
        };
    }

    public void attachWidthController(CompositeCloseable resources, TreeCellRenderer renderer) {
        if (this.myWidthController != null) {
            this.myWidthController.installListener();
            return;
        }
        this.myWidthController = new TreeTableWidthController(this, V8HeapTreeTable.createDisposable(resources));
        this.myWidthController.setMeaningfulRenderer(renderer);
    }

    @Override
    @Nullable
    public TreeTableWidthController getWidthController() {
        return this.myWidthController;
    }

    @NotNull
    private static Disposable createDisposable(@NotNull CompositeCloseable compositeCloseable) {
        if (compositeCloseable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compositeCloseable", "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapTreeTable", "createDisposable"));
        }
        final Disposable disposable = new Disposable(){

            public void dispose() {
            }
        };
        compositeCloseable.register(new Closeable(){

            @Override
            public void close() throws IOException {
                Disposer.dispose((Disposable)disposable);
            }
        });
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapTreeTable", "createDisposable"));
        }
        return disposable2;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int parentWidth = this.getParent().getWidth();
        if (this.myWidthController == null || parentWidth == 0) {
            return size;
        }
        int width = this.myWidthController.getWidth(parentWidth);
        return new Dimension(width, size.height);
    }

    public void smallerIndent() {
        V8Utils.setSmallerTreeIndent(this.getTree());
    }

    private V8HeapContainmentTreeTableModel.NamedEntry getNamedEntry(int row) {
        Object o;
        TreePath pathForRow = this.getTree().getPathForRow(row);
        if (pathForRow != null && (o = pathForRow.getLastPathComponent()) instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            return (V8HeapContainmentTreeTableModel.NamedEntry)o;
        }
        return null;
    }

    private Object getEntry(int row) {
        TreePath pathForRow = this.getTree().getPathForRow(row);
        if (pathForRow != null) {
            return pathForRow.getLastPathComponent();
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer;
        TableCellRenderer superRenderer = super.getCellRenderer(row, column);
        if (superRenderer instanceof TreeTableCellRenderer) {
            ((TreeTableCellRenderer)superRenderer).setCellRenderer(null);
        }
        return (renderer = ((TreeTableModelWithCustomRenderer)this.getTableModel()).getCustomizedRenderer(column, this.getEntry(row), superRenderer)) == null ? this.myDefaultTableRenderer : renderer;
    }
}

