/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.main;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.DialogUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveSnapshotDialog
extends FileSaverDialogImpl {
    @Nullable
    private final Project myProject;
    private JBCheckBox myOpenCreatedSnapshot;
    private JBCheckBox myShowHidden;

    public SaveSnapshotDialog(@NotNull FileSaverDescriptor descriptor, @Nullable Project project) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/nodejs/run/profile/heap/view/main/SaveSnapshotDialog", "<init>"));
        }
        super(descriptor, project);
        this.setTitle(NodeJSBundle.message("node.js.v8.heap.take.snapshot.dialog.title", new Object[0]));
        this.myProject = project;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent component = super.createSouthPanel();
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        this.myOpenCreatedSnapshot = new JBCheckBox(NodeJSBundle.message("node.js.v8.heap.take.snapshot.dialog.open.snapshot", new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myOpenCreatedSnapshot, (char)'&');
        this.myOpenCreatedSnapshot.setSelected(PropertiesComponent.getInstance((Project)this.myProject).getBoolean("Node.Profiling.Open.Snapshot.After.Save", true));
        panel.add((Component)this.myOpenCreatedSnapshot, (Object)"North");
        this.myShowHidden = new JBCheckBox(NodeJSBundle.message("node.js.v8.heap.take.snapshot.dialog.show.hidden", new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myShowHidden, (char)'&');
        panel.add((Component)this.myShowHidden, (Object)"Center");
        panel.add((Component)component, (Object)"South");
        return panel;
    }

    public boolean showHiddenData() {
        return this.myShowHidden.isSelected();
    }

    public boolean openCreatedSnapshot() {
        return this.myOpenCreatedSnapshot.isSelected();
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance((Project)this.myProject).setValue("Node.Profiling.Open.Snapshot.After.Save", String.valueOf(this.myOpenCreatedSnapshot.isSelected()));
        super.doOKAction();
    }
}

