/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.models;

import com.intellij.openapi.project.Project;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import org.jetbrains.annotations.NotNull;

public class V8HeapBiggestObjectTreeTableModel
extends V8HeapContainmentTreeTableModel {
    public V8HeapBiggestObjectTreeTableModel(Project project, @NotNull V8CachingReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/view/models/V8HeapBiggestObjectTreeTableModel", "<init>"));
        }
        super(project, reader);
        DirectTreeTableRenderer renderer = new DirectTreeTableRenderer(project, reader);
        this.setNodeRenderer(renderer);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.getRoot()) {
            Integer biggest = this.myReader.getBiggestObjects().get(index);
            V8HeapEntry node = this.myReader.getNode(biggest.intValue());
            V8HeapContainmentTreeTableModel.NamedEntry entry = new V8HeapContainmentTreeTableModel.NamedEntry(node, this.myReader.getString(node.getNameId()), "", -1L);
            entry.setDoNotShowLink(true);
            return entry;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.getRoot()) {
            return this.myReader.getBiggestObjects().size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.getRoot() && child instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            V8HeapContainmentTreeTableModel.NamedEntry entry = (V8HeapContainmentTreeTableModel.NamedEntry)child;
            long id = entry.getEntry().getId();
            for (int i = 0; i < this.myReader.getBiggestObjects().size(); ++i) {
                Integer object = this.myReader.getBiggestObjects().get(i);
                if ((long)object.intValue() != id) continue;
                return i;
            }
        }
        return 0;
    }
}

