/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.settings;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeProfilingRuntimeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingRuntimeSettingsImpl;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="profiling")
public class NodeProfilingSettings {
    public static final String DONT_APPLY_NODE_NM_MAC_FIX = "idea.nodejs.profiling.dont.apply.nm.fix";
    public static final String CPU_TOOL_WINDOW_TITLE = "V8 Profiling";
    public static final NotificationGroup CPU_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"V8 CPU Profiling Messages", (String)"V8 Profiling");
    public static final NotificationGroup HEAP_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"V8 Heap Snapshot Analysis Messages", (String)"V8 Heap");
    private static final String V8_PROFILER_PATH = "Node.Profiling.V8Profiler.Path";
    public static final String OPEN_TAKEN_SNAPSHOT = "Node.Profiling.Open.Snapshot.After.Save";
    public static final int DEFAULT_PORT = 43517;
    private boolean myProfile;
    private boolean myOpenViewer;
    @Nullable
    private String myLogFolder = ".";
    private boolean myOneLogFile;
    private boolean myAllowRuntimeHeapSnapshot;
    private String myV8ProfilerPackage;
    private int myInnerPort;

    public NodeProfilingSettings() {
        this.myProfile = false;
        this.myOpenViewer = true;
        this.myAllowRuntimeHeapSnapshot = false;
        this.myInnerPort = 43517;
    }

    public NodeProfilingSettings(NodeProfilingSettings settings) {
        this.myProfile = settings.myProfile;
        this.myOpenViewer = settings.myOpenViewer;
        this.myLogFolder = settings.myLogFolder;
        this.myOneLogFile = settings.myOneLogFile;
        this.myAllowRuntimeHeapSnapshot = settings.myAllowRuntimeHeapSnapshot;
        this.myV8ProfilerPackage = settings.myV8ProfilerPackage;
        this.myInnerPort = settings.myInnerPort;
    }

    public void check(@NotNull Project project, @NotNull NodeJsInterpreter interpreter) throws RuntimeConfigurationWarning, RuntimeConfigurationError {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "check"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "check"));
        }
        if (this.myProfile) {
            if (StringUtil.isEmptyOrSpaces((String)this.myLogFolder)) {
                throw new RuntimeConfigurationError("V8 profiling: no log folder defined.");
            }
            File file = new File(this.myLogFolder);
            if (!file.isAbsolute() && file.exists() && !file.isDirectory()) {
                throw new RuntimeConfigurationError(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.error.log.folder.isfile", new Object[0]));
            }
        }
        if (this.myAllowRuntimeHeapSnapshot && StringUtil.isEmptyOrSpaces((String)this.myV8ProfilerPackage)) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.error.not.defined", new Object[0]));
        }
        if (this.myAllowRuntimeHeapSnapshot && this.myInnerPort == -1) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.v8profiler.error.port.not.defined", new Object[0]));
        }
        if (this.myAllowRuntimeHeapSnapshot) {
            NodeProfilingSettings.checkNodeVersion(interpreter);
        }
    }

    private static void checkNodeVersion(@NotNull NodeJsInterpreter interpreter) throws RuntimeConfigurationWarning {
        String message;
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "checkNodeVersion"));
        }
        Ref versionRef = interpreter.getCachedVersion();
        if (versionRef != null && (message = NodeProfilingSettings.checkNodeVersion((SemVer)versionRef.get())) != null) {
            throw new RuntimeConfigurationWarning(message);
        }
    }

    @Nullable
    public static String checkNodeVersion(@Nullable SemVer semVer) {
        if (semVer != null && semVer.getMajor() == 0 && semVer.getMinor() < 11) {
            return NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.nodejs.version.hint", new Object[0]);
        }
        return null;
    }

    public void setProfile(boolean profile) {
        this.myProfile = profile;
    }

    public NodeProfilingRuntimeSettings createRuntimeSettings(@NotNull Project project, @NotNull String workingDirectory, @NotNull NodeFileTransfer fileTransfer) throws IOException, ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "createRuntimeSettings"));
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "createRuntimeSettings"));
        }
        if (fileTransfer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "createRuntimeSettings"));
        }
        if (!this.myProfile) {
            return null;
        }
        String suffix = NodeProfilingSettings.getDateTimeSuffix();
        File logFolder = this.getLocalLogFolder(project);
        NodeProfilingRuntimeSettingsImpl settings = new NodeProfilingRuntimeSettingsImpl(suffix, logFolder, workingDirectory, fileTransfer);
        settings.setNodeParameters(this.commandLineParameters(settings.getLogFileName()));
        return settings;
    }

    @NotNull
    private File getLocalLogFolder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "getLocalLogFolder"));
        }
        String nonNullLogFolder = StringUtil.notNullize((String)this.myLogFolder);
        if (".".equals(nonNullLogFolder)) {
            File file = new File(project.getBasePath());
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "getLocalLogFolder"));
            }
            return file;
        }
        File logFolder = new File(nonNullLogFolder);
        if (!logFolder.isAbsolute()) {
            logFolder = new File(project.getBasePath(), nonNullLogFolder);
        }
        File file = logFolder;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "getLocalLogFolder"));
        }
        return file;
    }

    @NotNull
    private String commandLineParameters(String logFileName) throws ExecutionException {
        StringBuilder sb = new StringBuilder("--prof");
        if (StringUtil.isEmptyOrSpaces((String)this.myLogFolder)) {
            throw new ExecutionException("V8 profiling: no log folder defined.");
        }
        if (this.myOneLogFile) {
            sb.append(" --nologfile_per_isolate");
        }
        sb.append(" --logfile=\"").append(logFileName).append("\"");
        sb.append(" --log-timer-events");
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "commandLineParameters"));
        }
        return string;
    }

    @NotNull
    private static String getDateTimeSuffix() {
        Date time1 = new Date();
        String date = DateFormatUtil.formatDate((Date)time1);
        String time = DateFormatUtil.formatTimeWithSeconds((Date)time1);
        String string = NodeProfilingSettings.escapeForFileName(date, '-') + "_" + NodeProfilingSettings.escapeForFileName(time, '-') + "-";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "getDateTimeSuffix"));
        }
        return string;
    }

    private static String escapeForFileName(String s, char symbol) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                result.append(c);
                continue;
            }
            result.append(symbol);
        }
        return result.toString();
    }

    public void setOpenViewer(boolean openViewer) {
        this.myOpenViewer = openViewer;
    }

    public void setLogFolder(@Nullable String logFolder) {
        this.myLogFolder = logFolder;
    }

    public void setInnerPort(int innerPort) {
        this.myInnerPort = innerPort;
    }

    public void setOneLogFile(boolean oneLogFile) {
        this.myOneLogFile = oneLogFile;
    }

    @Attribute(value="runtime-heap-snapshots-port")
    public int getInnerPort() {
        return this.myInnerPort;
    }

    @Attribute(value="do-profile")
    public boolean isProfile() {
        return this.myProfile;
    }

    @Attribute(value="open-viewer")
    public boolean isOpenViewer() {
        return this.myOpenViewer;
    }

    @Attribute(value="one-log-file")
    public boolean isOneLogFile() {
        return this.myOneLogFile;
    }

    @Attribute(value="log-folder")
    @Nullable
    public String getLogFolder() {
        return this.myLogFolder;
    }

    public void setAllowRuntimeHeapSnapshot(boolean allowRuntimeHeapSnapshot) {
        this.myAllowRuntimeHeapSnapshot = allowRuntimeHeapSnapshot;
    }

    @Attribute(value="allow-runtime-heap-snapshot")
    public boolean isAllowRuntimeHeapSnapshot() {
        return this.myAllowRuntimeHeapSnapshot;
    }

    public static NodeProfilingSettings readExternal(@NotNull Element element, @Nullable Project project) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "readExternal"));
        }
        Element state = element.getChild("profiling");
        NodeProfilingSettings settings = new NodeProfilingSettings();
        if (state != null) {
            XmlSerializer.deserializeInto((Object)settings, (Element)state);
        }
        if (settings.getV8ProfilerPackage() == null) {
            settings.setV8ProfilerPackage(PropertiesComponent.getInstance((Project)project).getValue(V8_PROFILER_PATH));
        }
        return settings;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/run/profile/settings/NodeProfilingSettings", "writeExternal"));
        }
        Element state = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!JDOMUtil.isEmpty((Element)state)) {
            element.addContent(state);
        }
    }

    @Attribute(value="v8-profiler-path")
    @Nullable
    public String getV8ProfilerPackage() {
        return this.myV8ProfilerPackage;
    }

    public void setV8ProfilerPackage(@Nullable String v8ProfilerPackage) {
        this.myV8ProfilerPackage = StringUtil.nullize((String)v8ProfilerPackage);
    }
}

