/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.settings;

import com.google.common.collect.Sets;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.library.NodeJsCoreLibraryConfigurator;
import com.jetbrains.nodejs.settings.NodeVersionListener;
import com.jetbrains.nodejs.settings.coreModules.NewSetupNodeCoreSourcesDialog;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreSourcesView
implements NodeVersionListener {
    private final Project myProject;
    private final VirtualFile myRequestor;
    private final JPanel myCardPanel;
    private final Set<Card> myRegisteredCards;
    private final Card myVersionNotFoundCard;
    private final Card myVersionUpdatingCard;
    private final NotEnabledLibraryCard myNotEnabledLibraryCard;
    private final EnabledLibraryCard myEnabledLibraryCard;

    public NodeCoreSourcesView(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "<init>"));
        }
        this.myRegisteredCards = Sets.newIdentityHashSet();
        this.myProject = project;
        this.myRequestor = requestor;
        this.myCardPanel = new JPanel(new CardLayout());
        this.myCardPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)NodeJSBundle.message("settings.nodejs.core_library.title", new Object[0]), (boolean)true));
        this.myVersionNotFoundCard = NodeCoreSourcesView.createVersionNotFoundCard();
        this.myVersionUpdatingCard = NodeCoreSourcesView.createVersionUpdatingCard();
        this.myNotEnabledLibraryCard = new NotEnabledLibraryCard();
        this.myEnabledLibraryCard = new EnabledLibraryCard();
        this.show(this.myVersionNotFoundCard);
    }

    @NotNull
    private static Card createVersionNotFoundCard() {
        Card card = new Card(){

            @Override
            @NotNull
            protected Component createComponent() {
                JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{new JLabel(NodeJSBundle.message("settings.nodejs.core_library.node_version_not_found", new Object[0]))});
                if (jPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$1", "createComponent"));
                }
                return jPanel;
            }
        };
        if (card == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "createVersionNotFoundCard"));
        }
        return card;
    }

    @NotNull
    private static Card createVersionUpdatingCard() {
        Card card = new Card(){

            @Override
            @NotNull
            public Component createComponent() {
                JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{new JLabel(NodeJSBundle.message("settings.nodejs.core_library.node_version_updating", new Object[0]))});
                if (jPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$2", "createComponent"));
                }
                return jPanel;
            }
        };
        if (card == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "createVersionUpdatingCard"));
        }
        return card;
    }

    private void show(@NotNull Card card) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "show"));
        }
        String cardName = NodeCoreSourcesView.getCardName(card);
        if (!this.myRegisteredCards.contains(card)) {
            this.myRegisteredCards.add(card);
            this.myCardPanel.add(card.getComponent(), cardName);
        }
        CardLayout layout = (CardLayout)this.myCardPanel.getLayout();
        layout.show(this.myCardPanel, cardName);
        this.myCardPanel.revalidate();
        this.myCardPanel.repaint();
    }

    @NotNull
    private static String getCardName(@NotNull Card card) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "getCardName"));
        }
        String string = String.valueOf(System.identityHashCode(card));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "getCardName"));
        }
        return string;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myCardPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "getComponent"));
        }
        return jPanel;
    }

    private void showCoreLibraryEnabled(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "showCoreLibraryEnabled"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "showCoreLibraryEnabled"));
        }
        this.myEnabledLibraryCard.update(interpreter, version);
        this.show(this.myEnabledLibraryCard);
    }

    private void showCoreLibraryNotEnabled(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "showCoreLibraryNotEnabled"));
        }
        this.myNotEnabledLibraryCard.update(interpreter);
        this.show(this.myNotEnabledLibraryCard);
    }

    @Override
    public void versionUpdateStarted() {
        this.show(this.myVersionUpdatingCard);
    }

    @Override
    public void versionUpdated(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer version) {
        if (interpreter == null || version == null) {
            this.show(this.myVersionNotFoundCard);
            return;
        }
        AtomicBoolean suggestEnabling = new AtomicBoolean(false);
        NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(this.myProject);
        SemVer currentVersion = configurator.getConfiguredCoreLibraryVersion();
        if (currentVersion == null || !currentVersion.getRawVersion().equals(version.getRawVersion())) {
            suggestEnabling.set(true);
        } else {
            ApplicationManager.getApplication().runReadAction(() -> {
                JSLibraryManager libraryManager = JSLibraryManager.getInstance((Project)this.myProject);
                ScriptingLibraryModel coreLibrary = libraryManager.getLibraryByName("Node.js Core");
                suggestEnabling.set(coreLibrary == null);
            });
        }
        if (suggestEnabling.get()) {
            this.showCoreLibraryNotEnabled(interpreter);
        } else {
            this.showCoreLibraryEnabled(interpreter, version);
        }
    }

    public static void enableCodeAssistance(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @Nullable VirtualFile requestor, @Nullable Runnable onDone) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "enableCodeAssistance"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "enableCodeAssistance"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/settings/NodeCoreSourcesView", "enableCodeAssistance"));
        }
        if (PlatformUtils.isIntelliJ()) {
            NewSetupNodeCoreSourcesDialog dialog = new NewSetupNodeCoreSourcesDialog(project, interpreter, version, requestor, onDone);
            dialog.show();
        } else {
            NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(project);
            configurator.configureAndAssociateWithProject(interpreter, version, onDone);
        }
    }

    private void showUsageScopeDialog() {
        JSLibraryMappings mappings = JSLibraryMappings.getInstance((Project)this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new ScriptingContextsConfigurable(this.myProject, (ScriptingLibraryMappings)mappings));
        ApplicationManager.getApplication().runWriteAction(() -> JSLibraryManager.getInstance((Project)this.myProject).commitChanges());
    }

    private class EnabledLibraryCard
    extends Card {
        private Runnable myDisableRunnable;

        private EnabledLibraryCard() {
        }

        @Override
        @NotNull
        public Component createComponent() {
            JPanel panel = new JPanel(new FlowLayout(0, JBUI.scale((int)10), 0));
            JLabel label = new JLabel(NodeJSBundle.message("settings.nodejs.core_library.enabled", "Node.js Core"));
            panel.add(label);
            JButton disableButton = new JButton("Disable");
            disableButton.setMnemonic('D');
            disableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnabledLibraryCard.this.myDisableRunnable.run();
                }
            });
            panel.add(disableButton);
            JButton usageScopeButton = new JButton("Usage scope...");
            usageScopeButton.setMnemonic('U');
            usageScopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeCoreSourcesView.this.showUsageScopeDialog();
                }
            });
            panel.add(usageScopeButton);
            JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{panel});
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$EnabledLibraryCard", "createComponent"));
            }
            return jPanel;
        }

        public void update(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version) {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$EnabledLibraryCard", "update"));
            }
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$EnabledLibraryCard", "update"));
            }
            this.myDisableRunnable = () -> {
                if (interpreter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$EnabledLibraryCard", "lambda$update$0"));
                }
                if (version == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$EnabledLibraryCard", "lambda$update$0"));
                }
                NodeJsCoreLibraryConfigurator.getInstance(NodeCoreSourcesView.this.myProject).disable();
                NodeCoreSourcesView.this.versionUpdated(interpreter, version);
            };
        }
    }

    private class NotEnabledLibraryCard
    extends Card {
        private Runnable myEnableRunnable;

        private NotEnabledLibraryCard() {
        }

        @Override
        @NotNull
        public Component createComponent() {
            JPanel panel = new JPanel(new FlowLayout(0, JBUI.scale((int)10), 0));
            JLabel label = new JLabel(NodeJSBundle.message("settings.nodejs.core_library.not_enabled", "Node.js Core"));
            panel.add(label);
            JButton enableButton = new JButton("Enable");
            enableButton.setMnemonic('E');
            enableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotEnabledLibraryCard.this.myEnableRunnable.run();
                }
            });
            panel.add(enableButton);
            JPanel jPanel = panel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$NotEnabledLibraryCard", "createComponent"));
            }
            return jPanel;
        }

        public void update(@NotNull NodeJsInterpreter interpreter) {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$NotEnabledLibraryCard", "update"));
            }
            this.myEnableRunnable = () -> {
                if (interpreter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$NotEnabledLibraryCard", "lambda$update$3"));
                }
                ModalityState modalityState = ModalityState.current();
                interpreter.provideCachedVersionOrFetch(version -> {
                    if (interpreter == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$NotEnabledLibraryCard", "lambda$null$2"));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (interpreter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$NotEnabledLibraryCard", "lambda$null$1"));
                        }
                        if (version == null) {
                            NodeCoreSourcesView.this.versionUpdated(interpreter, null);
                        } else {
                            NodeCoreSourcesView.enableCodeAssistance(NodeCoreSourcesView.this.myProject, interpreter, version, NodeCoreSourcesView.this.myRequestor, () -> {
                                if (interpreter == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$NotEnabledLibraryCard", "lambda$null$0"));
                                }
                                NodeCoreSourcesView.this.versionUpdated(interpreter, (SemVer)version);
                            });
                        }
                    }, modalityState, NodeCoreSourcesView.this.myProject.getDisposed());
                });
            };
        }
    }

    private static abstract class Card {
        private Component myComponent;

        private Card() {
        }

        @NotNull
        protected abstract Component createComponent();

        @NotNull
        public final Component getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            Component component = this.myComponent;
            if (component == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeCoreSourcesView$Card", "getComponent"));
            }
            return component;
        }
    }
}

