/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.settings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.settings.NodeSettingsView;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "settings.nodejs";
    private final Project myProject;
    private final VirtualFile myRequestor;
    private final boolean myOneClickConfiguration;
    private NodeSettingsView myView;
    private NodeJsInterpreterManager myInterpreterManager;

    public NodeSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/settings/NodeSettingsConfigurable", "<init>"));
        }
        this(project, null, false);
    }

    public NodeSettingsConfigurable(@NotNull Project project, @Nullable VirtualFile requestor, boolean oneClickConfiguration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/settings/NodeSettingsConfigurable", "<init>"));
        }
        this.myProject = project;
        this.myRequestor = requestor;
        this.myOneClickConfiguration = oneClickConfiguration;
        this.myInterpreterManager = NodeJsInterpreterManager.getInstance((Project)project);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/settings/NodeSettingsConfigurable", "getId"));
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return NodeJSBundle.message("settings.nodejs.name", new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        NodeSettingsView view;
        this.myView = view = new NodeSettingsView(this.myProject, this.myRequestor, this.myOneClickConfiguration);
        return view.getComponent();
    }

    public boolean isModified() {
        NodeSettingsView view = this.myView;
        if (view == null) {
            return false;
        }
        NodeJsInterpreter prev = this.myInterpreterManager.getDefault();
        NodeJsInterpreter next = view.getInterpreter();
        if (prev == null) {
            return next != null;
        }
        return !prev.deepEquals(next);
    }

    public void apply() throws ConfigurationException {
        NodeSettingsView view = this.myView;
        if (view != null) {
            NodeJsInterpreter interpreter = view.getInterpreter();
            this.myInterpreterManager.setDefault(interpreter);
        }
    }

    public void reset() {
        NodeSettingsView view = this.myView;
        if (view != null) {
            NodeJsInterpreter interpreter = this.myInterpreterManager.getDefault();
            view.setInterpreter(interpreter);
        }
    }
}

