/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.settings.coreModules;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionView;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.library.NodeJsCoreLibraryConfigurator;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewSetupNodeCoreSourcesDialog
extends DialogWrapper {
    private final Project myProject;
    private final NodeJsInterpreter myInterpreter;
    private final SemVer myNodeVersion;
    private final JComponent myCenterPanel;
    private final ModuleScopeSelectionView myModuleScopeSelectionView;
    private final Runnable myDone;

    public NewSetupNodeCoreSourcesDialog(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull SemVer nodeVersion, @Nullable VirtualFile requestor, @Nullable Runnable onDone) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/settings/coreModules/NewSetupNodeCoreSourcesDialog", "<init>"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/settings/coreModules/NewSetupNodeCoreSourcesDialog", "<init>"));
        }
        if (nodeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/settings/coreModules/NewSetupNodeCoreSourcesDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myInterpreter = interpreter;
        this.myNodeVersion = nodeVersion;
        this.myDone = onDone;
        this.setTitle("Configure Node.js v" + nodeVersion.getRawVersion() + " Core Library");
        this.myModuleScopeSelectionView = new ModuleScopeSelectionView(project, requestor, true, true);
        JPanel usageScopePanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{this.myModuleScopeSelectionView.getComponent()});
        usageScopePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)NodeJSBundle.message("settings.nodejs.core_library.title", new Object[0]), (boolean)true));
        this.myCenterPanel = usageScopePanel;
        SwingHelper.setPreferredWidth((Component)this.myCenterPanel, (int)JBUI.scale((int)350));
        this.setOKButtonText("Configure");
        this.init();
    }

    protected ValidationInfo doValidate() {
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.configureLibrary();
    }

    public void configureLibrary() {
        NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(this.myProject);
        List roots = this.myModuleScopeSelectionView.getLibraryScope();
        configurator.configureAndAssociateWith(this.myInterpreter, this.myNodeVersion, roots, this.myDone);
    }
}

